/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.internal;

import io.freefair.gradle.plugins.okhttp.internal.ProgressListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final ProgressListener progressListener;
    private BufferedSource bufferedSource;

    ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener) {
        this.responseBody = responseBody;
        this.progressListener = progressListener;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    @Nonnull
    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    public void close() {
        super.close();
        this.responseBody.close();
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(@Nonnull Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                ProgressResponseBody.this.progressListener.readUpdate(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength());
                return bytesRead;
            }
        };
    }
}

