/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.tasks;

import io.freefair.gradle.plugins.okhttp.internal.ProgressInterceptor;
import io.freefair.gradle.plugins.okhttp.internal.ProgressListener;
import io.freefair.gradle.plugins.okhttp.tasks.OkHttpTask;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import javax.inject.Inject;
import lombok.Generated;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.gradle.api.GradleException;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;

public abstract class OkHttpRequestTask
extends OkHttpTask {
    @Inject
    protected abstract ProgressLoggerFactory getProgressLoggerFactory();

    @Input
    public abstract Property<String> getUrl();

    @Input
    public abstract MapProperty<String, String> getHeaders();

    @Input
    @Optional
    public abstract Property<String> getUsername();

    @Input
    @Optional
    public abstract Property<String> getPassword();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void executeRequest() throws IOException {
        ProgressLogger progressLogger = this.getProgressLoggerFactory().newOperation(OkHttpRequestTask.class);
        Request request = this.buildRequest(new Request.Builder()).build();
        OkHttpClient client = this.getOkHttpClient();
        client = client.newBuilder().addNetworkInterceptor((Interceptor)new ProgressInterceptor(new GradleProcessListener(progressLogger))).build();
        progressLogger.start(request.toString(), "Call");
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            this.handleResponse(response);
        }
        finally {
            progressLogger.completed();
        }
    }

    public Request.Builder buildRequest(Request.Builder builder) {
        ((Map)this.getHeaders().get()).forEach((arg_0, arg_1) -> ((Request.Builder)builder).header(arg_0, arg_1));
        if (this.getUsername().isPresent() && this.getPassword().isPresent()) {
            builder.header("Authorization", Credentials.basic((String)((String)this.getUsername().get()), (String)((String)this.getPassword().get())));
        }
        if (this.getUrl().isPresent()) {
            builder.url((String)this.getUrl().get());
        }
        return builder;
    }

    public void handleResponse(Response response) throws IOException {
        if (!response.isSuccessful()) {
            this.getLogger().error("{}: {}", (Object)response.code(), (Object)response.message());
            this.getLogger().error(response.body().string());
            throw new GradleException(response.message());
        }
    }

    private static class GradleProcessListener
    implements ProgressListener {
        private final ProgressLogger progressLogger;
        private long uploadStart;
        private long downloadStart;

        @Override
        public void readUpdate(long bytesRead, long contentLength) {
            if (this.downloadStart == 0L) {
                this.downloadStart = System.nanoTime();
            }
            this.update("Download", bytesRead, contentLength, this.downloadStart);
        }

        @Override
        public void writeUpdate(long bytesWritten, long contentLength) {
            if (this.uploadStart == 0L) {
                this.uploadStart = System.nanoTime();
            }
            this.update("Upload", bytesWritten, contentLength, this.uploadStart);
        }

        private void update(String prefix, long bytes, long contentLength, long startNanos) {
            Duration currentDuration = Duration.ofNanos(System.nanoTime() - startNanos);
            double bps = (double)bytes / (double)currentDuration.toMillis() * 1000.0;
            if (contentLength < 1L) {
                this.progressLogger.progress(String.format("%s %s [%s/s]", prefix, this.makeHumanReadable(bytes), this.makeHumanReadable(bps)));
            } else {
                double percent = (double)bytes / (double)contentLength * 100.0;
                this.progressLogger.progress(String.format("%s %.2f%% (%s / %s) [%s/s]", prefix, percent, this.makeHumanReadable(bytes), this.makeHumanReadable(contentLength), this.makeHumanReadable(bps)));
            }
        }

        private String makeHumanReadable(double bytes) {
            if (bytes < 1024.0) {
                return String.format("%.2f B", bytes);
            }
            double kib = bytes / 1024.0;
            if (kib < 1024.0) {
                return String.format("%.2f KiB", kib);
            }
            double mib = kib / 1024.0;
            if (mib < 1024.0) {
                return String.format("%.2f MiB", mib);
            }
            double gib = mib / 1024.0;
            if (gib < 1024.0) {
                return String.format("%.2f GiB", gib);
            }
            double tib = gib / 1024.0;
            return String.format("%.2f TiB", tib);
        }

        @Generated
        public GradleProcessListener(ProgressLogger progressLogger) {
            this.progressLogger = progressLogger;
        }
    }
}

