/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.okhttp.tasks;

import io.freefair.gradle.plugins.okhttp.internal.CacheControlInterceptor;
import java.io.File;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;

public abstract class OkHttpTask
extends DefaultTask {
    @Internal
    private OkHttpClient okHttpClient;

    @Console
    public abstract Property<HttpLoggingInterceptor.Level> getLoggingLevel();

    @Internal
    @Optional
    public abstract DirectoryProperty getCacheDir();

    @Input
    @Optional
    public abstract Property<Integer> getCacheSize();

    @Input
    @Optional
    public abstract Property<Boolean> getForceCache();

    @Input
    @Optional
    public abstract Property<Boolean> getForceNetwork();

    public OkHttpTask() {
        this.getCacheSize().convention((Object)0xA00000);
        this.getCacheDir().fileValue(this.getTemporaryDir());
        this.getForceCache().convention((Object)this.getProject().getGradle().getStartParameter().isOffline());
        this.getForceNetwork().convention((Object)this.getProject().getGradle().getStartParameter().isRefreshDependencies());
    }

    protected OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = this.buildOkHttpClient();
        }
        return this.okHttpClient;
    }

    protected OkHttpClient buildOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        File cacheDir = (File)this.getCacheDir().getAsFile().getOrNull();
        int cacheSize = (Integer)this.getCacheSize().getOrElse((Object)0);
        if (cacheDir != null && cacheSize > 1) {
            Cache cache = new Cache(cacheDir, (long)cacheSize);
            builder = builder.cache(cache);
        }
        if (((Boolean)this.getForceCache().getOrElse((Object)false)).booleanValue()) {
            builder = builder.addInterceptor((Interceptor)new CacheControlInterceptor(CacheControl.FORCE_CACHE));
        } else if (((Boolean)this.getForceNetwork().getOrElse((Object)false)).booleanValue()) {
            builder = builder.addInterceptor((Interceptor)new CacheControlInterceptor(CacheControl.FORCE_NETWORK));
        }
        if (this.getLoggingLevel().isPresent()) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(s -> this.getLogger().lifecycle(s));
            loggingInterceptor.level((HttpLoggingInterceptor.Level)this.getLoggingLevel().get());
            builder = builder.addInterceptor((Interceptor)loggingInterceptor);
        }
        return builder.build();
    }
}

