/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.util;

import lombok.Generated;
import org.gradle.api.Project;
import org.gradle.process.ExecOutput;

public final class GitUtil {
    public static boolean isTravisCi() {
        return "true".equalsIgnoreCase(System.getenv("TRAVIS"));
    }

    public static boolean isCircleCi() {
        return "true".equalsIgnoreCase(System.getenv("CIRCLECI"));
    }

    public static boolean isGithubActions() {
        return "true".equalsIgnoreCase(System.getenv("GITHUB_ACTIONS"));
    }

    public static boolean isJenkins() {
        return System.getenv("JENKINS_HOME") != null;
    }

    public static String getSha(Project project) {
        if (GitUtil.isGithubActions()) {
            return System.getenv("GITHUB_SHA");
        }
        if (GitUtil.isTravisCi()) {
            return System.getenv("TRAVIS_COMMIT");
        }
        if (GitUtil.isCircleCi()) {
            return System.getenv("CIRCLE_SHA1");
        }
        return GitUtil.execute(project, "git", "rev-parse", "HEAD");
    }

    public static String getRef(Project project) {
        if (GitUtil.isGithubActions()) {
            return System.getenv("GITHUB_REF");
        }
        return GitUtil.execute(project, "git", "symbolic-ref", "HEAD");
    }

    public static String execute(Project project, String ... command) {
        ExecOutput execOutput = project.getProviders().exec(execSpec -> {
            execSpec.setWorkingDir(project.getProjectDir());
            execSpec.commandLine((Object[])command);
        });
        return (String)execOutput.getStandardOutput().getAsText().map(String::trim).get();
    }

    @Generated
    private GitUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

