/*
 * Decompiled with CFR 0.152.
 */
package io.fria.lilo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDefaultRemoteRetriever {
    private static final int RESPONSE_STREAM_BUFFER_SIZE = 4096;

    protected String retrieve(@NotNull String schemaUrl, @NotNull String query) {
        byte[] response;
        try {
            int bytesRead;
            URL url = new URL(schemaUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            OutputStream remoteOutputStream = conn.getOutputStream();
            byte[] input = query.getBytes(StandardCharsets.UTF_8);
            remoteOutputStream.write(input, 0, input.length);
            remoteOutputStream.flush();
            remoteOutputStream.close();
            InputStream responseInputStream = conn.getInputStream();
            ByteArrayOutputStream responseOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead = responseInputStream.read(buffer)) != -1) {
                responseOutputStream.write(buffer, 0, bytesRead);
            }
            response = responseOutputStream.toByteArray();
            responseOutputStream.close();
            responseInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(response, StandardCharsets.UTF_8);
    }
}

