/*
 * Decompiled with CFR 0.152.
 */
package io.fsq.exceptionator.service;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.twitter.finagle.CodecFactory;
import com.twitter.finagle.Filter;
import com.twitter.finagle.Service;
import com.twitter.finagle.builder.Server;
import com.twitter.finagle.builder.ServerBuilder$;
import com.twitter.finagle.builder.ServerConfigEvidence;
import com.twitter.finagle.http.Http$;
import com.twitter.finagle.http.filter.ExceptionFilter$;
import com.twitter.finagle.stats.OstrichStatsReceiver;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Logger;
import com.twitter.ostrich.admin.AdminServiceFactory;
import com.twitter.ostrich.admin.AdminServiceFactory$;
import com.twitter.ostrich.admin.RuntimeEnvironment;
import com.twitter.ostrich.admin.StatsFactory;
import com.twitter.ostrich.admin.StatsFactory$;
import com.twitter.ostrich.admin.TimeSeriesCollectorFactory;
import com.typesafe.config.Config;
import io.fsq.common.logging.Logger;
import io.fsq.exceptionator.actions.BackgroundActions;
import io.fsq.exceptionator.actions.HasBucketActions;
import io.fsq.exceptionator.actions.IncomingActions;
import io.fsq.exceptionator.actions.concrete.ConcreteBackgroundActions;
import io.fsq.exceptionator.actions.concrete.ConcreteBucketActions;
import io.fsq.exceptionator.actions.concrete.ConcreteHistoryActions;
import io.fsq.exceptionator.actions.concrete.ConcreteIncomingActions;
import io.fsq.exceptionator.actions.concrete.ConcreteNoticeActions;
import io.fsq.exceptionator.actions.concrete.FilteredConcreteIncomingActions;
import io.fsq.exceptionator.loader.concrete.ConcretePluginLoaderService;
import io.fsq.exceptionator.loader.service.HasPluginLoaderService;
import io.fsq.exceptionator.model.gen.BucketRecord$;
import io.fsq.exceptionator.model.gen.BucketRecordHistogram$;
import io.fsq.exceptionator.model.gen.HistoryRecord$;
import io.fsq.exceptionator.model.gen.NoticeRecord$;
import io.fsq.exceptionator.mongo.HasExceptionatorMongoService;
import io.fsq.exceptionator.mongo.concrete.ConcreteExceptionatorMongoService;
import io.fsq.exceptionator.mongo.concrete.ConcreteExceptionatorMongoService$;
import io.fsq.exceptionator.service.ApiHttpService;
import io.fsq.exceptionator.service.DefaultRequestEnricher;
import io.fsq.exceptionator.service.ExceptionatorHttpService;
import io.fsq.exceptionator.service.ExceptionatorServer$;
import io.fsq.exceptionator.service.IncomingHttpService;
import io.fsq.exceptionator.service.StaticFileService;
import io.fsq.exceptionator.util.Config$;
import io.fsq.rogue.adapter.BlockingResult;
import io.fsq.rogue.connection.DefaultMongoIdentifier;
import io.fsq.rogue.connection.MongoIdentifier;
import io.fsq.rogue.index.UntypedMongoIndex;
import io.fsq.spindle.runtime.MetaRecord;
import io.fsq.spindle.runtime.UntypedMetaRecord;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ExceptionatorServer$
implements io.fsq.common.logging.Logger {
    public static final ExceptionatorServer$ MODULE$;
    private final int defaultPort;
    private final int defaultStatsPort;
    private final String defaultDbHost;
    private final String defaultDbName;
    private final DefaultMongoIdentifier defaultMongoIdentifier;
    private final Logger logger;

    static {
        new ExceptionatorServer$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void io$fsq$common$logging$Logger$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    public int defaultStatsPort() {
        return this.defaultStatsPort;
    }

    public String defaultDbHost() {
        return this.defaultDbHost;
    }

    public String defaultDbName() {
        return this.defaultDbName;
    }

    public DefaultMongoIdentifier defaultMongoIdentifier() {
        return this.defaultMongoIdentifier;
    }

    public void bootMongo(HasExceptionatorMongoService services, Seq<UntypedMetaRecord> ensureIndexesMetaRecords) {
        Runtime.getRuntime().addShutdownHook(new Thread(services){
            private final HasExceptionatorMongoService services$1;

            public void run() {
                this.services$1.exceptionatorMongo().clientManager().closeAll();
            }
            {
                this.services$1 = services$1;
            }
        });
        ServerAddress[] serverAddresses = (ServerAddress[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString((String)Config$.MODULE$.opt((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Config x$1) {
                return x$1.getString("db.host");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ExceptionatorServer$.MODULE$.defaultDbHost();
            }
        }))).split(',')).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ServerAddress apply(String hostString) {
                block4: {
                    ServerAddress serverAddress;
                    block3: {
                        String[] stringArray;
                        block2: {
                            stringArray = new StringOps(Predef$.MODULE$.augmentString(hostString)).split(':');
                            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) break block2;
                            String host = (String)((SeqLike)option.get()).apply(0);
                            String port = (String)((SeqLike)option.get()).apply(1);
                            serverAddress = new ServerAddress(host, new StringOps(Predef$.MODULE$.augmentString(port)).toInt());
                            break block3;
                        }
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(1) != 0) break block4;
                        String host = (String)((SeqLike)option.get()).apply(0);
                        serverAddress = new ServerAddress(host);
                    }
                    return serverAddress;
                }
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed host string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostString})));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServerAddress.class)));
        MongoClientOptions mongoOptions = MongoClientOptions.builder().socketTimeout((int)ConcreteExceptionatorMongoService$.MODULE$.defaultDbSocketTimeoutMS()).build();
        MongoClient client = new MongoClient(Arrays.asList((Object[])serverAddresses), mongoOptions);
        String dbName = (String)Config$.MODULE$.opt((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Config x$2) {
                return x$2.getString("db.name");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ExceptionatorServer$.MODULE$.defaultDbName();
            }
        });
        services.exceptionatorMongo().clientManager().defineDb((MongoIdentifier)this.defaultMongoIdentifier(), (Object)client, dbName);
        ensureIndexesMetaRecords.foreach((Function1)new Serializable(services){
            public static final long serialVersionUID = 0L;
            public final HasExceptionatorMongoService services$1;

            public final void apply(UntypedMetaRecord metaRecord) {
                this.services$1.exceptionatorMongo().collectionFactory().getIndexes(metaRecord).foreach((Function1)new Serializable(this, metaRecord){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.bootMongo.1 $outer;
                    private final UntypedMetaRecord metaRecord$1;

                    public final BlockingResult<Seq<String>> apply(Seq<UntypedMongoIndex> x$3) {
                        return (BlockingResult)this.$outer.services$1.exceptionatorMongo().executor().createIndexes((Object)this.metaRecord$1, x$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metaRecord$1 = metaRecord$1;
                    }
                });
            }
            {
                this.services$1 = services$1;
            }
        });
    }

    public Seq<UntypedMetaRecord> bootMongo$default$2() {
        return Nil$.MODULE$;
    }

    public void main(String[] args) {
        this.logger().info("Starting ExceptionatorServer", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Config$.MODULE$.defaultInit();
        HasBucketActions services = new HasBucketActions(){
            private ConcreteHistoryActions historyActions;
            private ConcreteNoticeActions noticeActions;
            private ConcretePluginLoaderService pluginLoader;
            private ConcreteBucketActions bucketActions;
            private ConcreteExceptionatorMongoService exceptionatorMongo;
            private volatile byte bitmap$0;

            private ConcreteHistoryActions historyActions$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.historyActions = new ConcreteHistoryActions((HasBucketActions)this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                    return this.historyActions;
                }
            }

            private ConcreteNoticeActions noticeActions$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.noticeActions = new ConcreteNoticeActions((HasExceptionatorMongoService)this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                    return this.noticeActions;
                }
            }

            private ConcretePluginLoaderService pluginLoader$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 4) == 0) {
                        this.pluginLoader = new ConcretePluginLoaderService((HasBucketActions)this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                    }
                    return this.pluginLoader;
                }
            }

            private ConcreteBucketActions bucketActions$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 8) == 0) {
                        this.bucketActions = new ConcreteBucketActions((HasExceptionatorMongoService)this);
                        this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                    }
                    return this.bucketActions;
                }
            }

            private ConcreteExceptionatorMongoService exceptionatorMongo$lzycompute() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 0x10) == 0) {
                        this.exceptionatorMongo = new ConcreteExceptionatorMongoService();
                        this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                    }
                    return this.exceptionatorMongo;
                }
            }

            public ConcreteHistoryActions historyActions() {
                return (byte)(this.bitmap$0 & 1) == 0 ? this.historyActions$lzycompute() : this.historyActions;
            }

            public ConcreteNoticeActions noticeActions() {
                return (byte)(this.bitmap$0 & 2) == 0 ? this.noticeActions$lzycompute() : this.noticeActions;
            }

            public ConcretePluginLoaderService pluginLoader() {
                return (byte)(this.bitmap$0 & 4) == 0 ? this.pluginLoader$lzycompute() : this.pluginLoader;
            }

            public ConcreteBucketActions bucketActions() {
                return (byte)(this.bitmap$0 & 8) == 0 ? this.bucketActions$lzycompute() : this.bucketActions;
            }

            public ConcreteExceptionatorMongoService exceptionatorMongo() {
                return (byte)(this.bitmap$0 & 0x10) == 0 ? this.exceptionatorMongo$lzycompute() : this.exceptionatorMongo;
            }
        };
        FilteredConcreteIncomingActions incomingActions = new FilteredConcreteIncomingActions((Service)new ConcreteIncomingActions(services));
        try {
            this.bootMongo((HasExceptionatorMongoService)services, (Seq<UntypedMetaRecord>)((Seq)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetaRecord[]{BucketRecord$.MODULE$, BucketRecordHistogram$.MODULE$, HistoryRecord$.MODULE$, NoticeRecord$.MODULE$}))));
        }
        catch (Exception exception) {
            this.logger().error((Throwable)exception, "Failed to connect to mongo", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            System.exit(1);
        }
        ConcreteBackgroundActions backgroundActions = new ConcreteBackgroundActions((HasPluginLoaderService)services);
        RuntimeEnvironment runtime = new RuntimeEnvironment((Object)this);
        List x$7 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeSeriesCollectorFactory[]{new TimeSeriesCollectorFactory()}));
        String x$8 = StatsFactory$.MODULE$.apply$default$1();
        new AdminServiceFactory(BoxesRunTime.unboxToInt((Object)Config$.MODULE$.opt((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Config x$4) {
                return x$4.getInt("stats.port");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ExceptionatorServer$.MODULE$.defaultStatsPort();
            }
        })), AdminServiceFactory$.MODULE$.apply$default$2(), AdminServiceFactory$.MODULE$.apply$default$3(), AdminServiceFactory$.MODULE$.apply$default$4(), AdminServiceFactory$.MODULE$.apply$default$5(), AdminServiceFactory$.MODULE$.apply$default$6(), AdminServiceFactory$.MODULE$.apply$default$7()).addStatsFactory(new StatsFactory(x$8, x$7)).apply(runtime);
        int httpPort = BoxesRunTime.unboxToInt((Object)Config$.MODULE$.opt((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Config x$5) {
                return x$5.getInt("http.port");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ExceptionatorServer$.MODULE$.defaultPort();
            }
        }));
        String pathPrefix = (String)Config$.MODULE$.opt((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Config x$6) {
                return x$6.getString("web.pathPrefix");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Starting ExceptionatorHttpService on port %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)httpPort)})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Service service = ExceptionFilter$.MODULE$.andThen((Filter)new DefaultRequestEnricher()).andThen((Service)new ExceptionatorHttpService(new StaticFileService(pathPrefix), new ApiHttpService(services, (Map<String, String>)incomingActions.bucketFriendlyNames()), new IncomingHttpService((IncomingActions)incomingActions, (BackgroundActions)backgroundActions)));
        Server server = ServerBuilder$.MODULE$.apply().bindTo((SocketAddress)new InetSocketAddress(httpPort)).codec((CodecFactory)Http$.MODULE$.get()).name("exceptionator-http").reportTo((StatsReceiver)new OstrichStatsReceiver()).build(service, (ServerConfigEvidence)ServerConfigEvidence.FullyConfigured$.MODULE$);
    }

    private ExceptionatorServer$() {
        MODULE$ = this;
        Logger.class.$init$((io.fsq.common.logging.Logger)this);
        this.defaultPort = 8080;
        this.defaultStatsPort = this.defaultPort() + 1;
        this.defaultDbHost = "localhost:27017";
        this.defaultDbName = "test";
        this.defaultMongoIdentifier = new DefaultMongoIdentifier("exceptionator");
    }
}

