/*
 * Decompiled with CFR 0.152.
 */
package io.fsq.twofishes.indexer.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.fsq.common.scala.Identity$;
import io.fsq.rogue.QueryOptimizer;
import io.fsq.rogue.adapter.BlockingMongoClientAdapter;
import io.fsq.rogue.adapter.BlockingResult;
import io.fsq.rogue.adapter.MongoClientAdapter;
import io.fsq.rogue.adapter.MongoCollectionFactory;
import io.fsq.rogue.connection.BlockingMongoClientManager;
import io.fsq.rogue.connection.DefaultMongoIdentifier;
import io.fsq.rogue.connection.MongoClientManager;
import io.fsq.rogue.connection.MongoIdentifier;
import io.fsq.rogue.query.QueryExecutor;
import io.fsq.rogue.query.RogueSerializer;
import io.fsq.rogue.util.DefaultQueryUtilities;
import io.fsq.rogue.util.QueryUtilities;
import io.fsq.spindle.rogue.SpindleHelpers$;
import io.fsq.spindle.rogue.adapter.SpindleMongoCollectionFactory;
import io.fsq.spindle.rogue.query.SpindleRogueSerializer;
import io.fsq.spindle.runtime.UntypedMetaRecord;
import io.fsq.spindle.runtime.UntypedRecord;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class IndexerQueryExecutor$ {
    public static final IndexerQueryExecutor$ MODULE$;
    private final DefaultMongoIdentifier mongoIdentifier;
    private BlockingMongoClientManager clientManager;
    private QueryExecutor<MongoCollection, Object, BasicDBObject, UntypedMetaRecord, UntypedRecord, BlockingResult> instance;
    private final int RequiredMongoMajorVersion;
    private volatile byte bitmap$0;

    static {
        new IndexerQueryExecutor$();
    }

    /*
     * WARNING - void declaration
     */
    private BlockingMongoClientManager clientManager$lzycompute() {
        IndexerQueryExecutor$ indexerQueryExecutor$ = this;
        synchronized (indexerQueryExecutor$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                BlockingMongoClientManager manager = new BlockingMongoClientManager();
                Runtime.getRuntime().addShutdownHook(new Thread(manager){
                    private final BlockingMongoClientManager manager$1;

                    public void run() {
                        this.manager$1.closeAll();
                    }
                    {
                        this.manager$1 = manager$1;
                    }
                });
                this.clientManager = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.clientManager;
        }
    }

    private QueryExecutor instance$lzycompute() {
        IndexerQueryExecutor$ indexerQueryExecutor$ = this;
        synchronized (indexerQueryExecutor$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                MongoClient mongoClient;
                Option option = Option$.MODULE$.apply((Object)System.getProperty("mongodb.server"));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String address = (String)some.x();
                    mongoClient = new MongoClient(new MongoClientURI(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mongodb://", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                } else {
                    if (!None$.MODULE$.equals(option)) {
                        throw new MatchError((Object)option);
                    }
                    mongoClient = new MongoClient();
                }
                MongoClient mongoClient2 = mongoClient;
                this.clientManager().defineDb((MongoIdentifier)this.mongoIdentifier(), (Object)mongoClient2, "geocoder");
                this.ensureMongoVersionOrEmitHelpfulErrorMessage();
                SpindleMongoCollectionFactory collectionFactory = new SpindleMongoCollectionFactory((MongoClientManager)this.clientManager());
                DefaultQueryUtilities queryUtilities = new DefaultQueryUtilities();
                BlockingMongoClientAdapter clientAdapter = new BlockingMongoClientAdapter((MongoCollectionFactory)collectionFactory, (QueryUtilities)queryUtilities);
                QueryOptimizer optimizer = new QueryOptimizer();
                SpindleRogueSerializer serializer = new SpindleRogueSerializer();
                this.instance = new QueryExecutor((MongoClientAdapter)clientAdapter, optimizer, (RogueSerializer)serializer);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.instance;
        }
    }

    private DefaultMongoIdentifier mongoIdentifier() {
        return this.mongoIdentifier;
    }

    private BlockingMongoClientManager clientManager() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.clientManager$lzycompute() : this.clientManager;
    }

    public QueryExecutor<MongoCollection, Object, BasicDBObject, UntypedMetaRecord, UntypedRecord, BlockingResult> instance() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.instance$lzycompute() : this.instance;
    }

    public int RequiredMongoMajorVersion() {
        return this.RequiredMongoMajorVersion;
    }

    private void ensureMongoVersionOrEmitHelpfulErrorMessage() {
        try {
            MongoDatabase db = (MongoDatabase)this.clientManager().getDbOrThrow((MongoIdentifier)this.mongoIdentifier());
            Document resultDoc = db.runCommand((Bson)new BsonDocument("buildinfo", (BsonValue)new BsonInt32(1)));
            String versionString = resultDoc.getString((Object)"version");
            int majorVersionInt = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(versionString)).takeWhile((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$1) {
                    return Identity$.MODULE$.$bang$eq$qmark$extension(Identity$.MODULE$.wrapIdentity((Object)BoxesRunTime.boxToCharacter((char)x$1)), (Object)BoxesRunTime.boxToCharacter((char)'.'));
                }
            }))).toInt();
            if (majorVersionInt < this.RequiredMongoMajorVersion()) {
                this.withErrorBanner$1((Function0)new Serializable(versionString){
                    public static final long serialVersionUID = 0L;
                    private final String versionString$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"It looks like you're using a Mongo server of version < 3.x! (Got version: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.versionString$1})));
                        Predef$.MODULE$.println((Object)"The indexer build now requires a mongod >= 3.x. Please upgrade your server and try again.");
                    }
                    {
                        this.versionString$1 = versionString$1;
                    }
                });
                System.exit(1);
            }
        }
        catch (Exception exception) {
            this.withErrorBanner$1((Function0)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Error while getting MongoDB version info: ").append((Object)this.e$1).toString());
                    this.e$1.printStackTrace();
                }
                {
                    this.e$1 = e$1;
                }
            });
            System.exit(1);
        }
    }

    public void dropCollection(UntypedMetaRecord meta) {
        this.clientManager().useCollection((MongoIdentifier)new DefaultMongoIdentifier(SpindleHelpers$.MODULE$.getIdentifier(meta)), SpindleHelpers$.MODULE$.getCollection(meta), BasicDBObject.class, this.clientManager().useCollection$default$4(), this.clientManager().useCollection$default$5(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(MongoCollection<BasicDBObject> coll) {
                coll.drop();
            }
        });
    }

    private final void withErrorBanner$1(Function0 f) {
        String rule = ((TraversableOnce)List$.MODULE$.fill(50, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final char apply() {
                return this.apply$mcC$sp();
            }

            public char apply$mcC$sp() {
                return '=';
            }
        })).mkString();
        String banner = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ERROR ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rule, rule}));
        Predef$.MODULE$.println((Object)banner);
        f.apply$mcV$sp();
        Predef$.MODULE$.println((Object)banner);
    }

    private IndexerQueryExecutor$() {
        MODULE$ = this;
        this.mongoIdentifier = new DefaultMongoIdentifier("geocoder");
        this.RequiredMongoMajorVersion = 3;
    }
}

