package io.fullview.fullview_sdk

import co.daily.model.AvailableDevices
import co.daily.model.CallState
import co.daily.model.MediaStreamTrack
import co.daily.model.Participant
import co.daily.model.ParticipantId

// As an optimization for larger calls, it would be possible to modify this to
// represent state updates rather than entire state snapshots. The MainActivity
// could then respond to only the parts of the state which have changed.

data class DailyState(
    val status: CallState,
    val inputs: StreamsState,
    val publishing: StreamsState,
    val localParticipantTrack: MediaStreamTrack?,
    val allParticipants: Map<ParticipantId, Participant>,
    val availableDevices: AvailableDevices,
    val activeAudioDevice: String?,
    val screenShareActive: Boolean,
) {
    data class StreamsState(
        val cameraEnabled: Boolean,
        val micEnabled: Boolean,
        val screenVideoEnabled: Boolean
    )

    fun with(
        newStatus: CallState = status,
        newInputs: StreamsState = inputs,
        newPublishing: StreamsState = publishing,
        newLocalParticipantTrack: MediaStreamTrack? = localParticipantTrack,
        newAllParticipants: Map<ParticipantId, Participant> = allParticipants,
        newAvailableDevices: AvailableDevices = availableDevices,
        newActiveAudioDevice: String? = activeAudioDevice,
        newScreenShareActive: Boolean = screenShareActive,
    ) = DailyState(
        newStatus,
        newInputs,
        newPublishing,
        newLocalParticipantTrack,
        newAllParticipants,
        newAvailableDevices,
        newActiveAudioDevice,
        newScreenShareActive
    )

    companion object {
        fun default(): DailyState = DailyState(
            status = CallState.initialized,
            inputs = StreamsState(cameraEnabled = false, micEnabled = false, screenVideoEnabled = false),
            publishing = StreamsState(cameraEnabled = false, micEnabled = false, screenVideoEnabled = false),
            localParticipantTrack = null,
            allParticipants = emptyMap(),
            availableDevices = AvailableDevices(
                camera = emptyList(),
                microphone = emptyList(),
                speaker = emptyList(),
                audio = emptyList()
            ),
            activeAudioDevice = null,
            screenShareActive = false
        )
    }
}
