package io.fullview.fullview_sdk.data

import access.models.RegisterCustomerResponse
import android.os.Parcelable
import androidx.annotation.Keep
import io.fullview.fullview_sdk.Region
import kotlinx.parcelize.Parcelize

@Keep
@Parcelize
data class User(
    val id: String,
    val accessToken: String,
    val siloId: String,
    val region: Region
) : Parcelable

@Keep
fun RegisterCustomerResponse.toUser(region: Region) : User = User(id, accessToken, siloId, region)