package io.fullview.fullview_sdk.helpers


import android.view.SurfaceView
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.IntrinsicSize
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.viewinterop.AndroidView

@Composable
fun DataRedaction(
    modifier: Modifier = Modifier,
    content: @Composable () -> Unit
) {
    Box(modifier = modifier.height(IntrinsicSize.Min).width(IntrinsicSize.Min)) {
        content()
        AndroidView(
            factory = { context ->
                SurfaceView(context)
                    .apply {
                        setSecure(true)
                        setZOrderOnTop(true)
                        isDrawingCacheEnabled = true
                        drawingCacheBackgroundColor = resources.getColor(android.R.color.black)
                        layoutParams = ViewGroup.LayoutParams(MATCH_PARENT, MATCH_PARENT)
                    }
            },
            modifier = Modifier.fillMaxHeight().fillMaxWidth()
        )
    }
}