package io.fullview.fullview_sdk.helpers

import android.annotation.SuppressLint
import android.view.KeyEvent
import android.view.MotionEvent
import android.view.View
import androidx.compose.runtime.Composable
import androidx.compose.ui.ExperimentalComposeUiApi
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.pointerInteropFilter


/**
 *  Prevents Fullview SDK to perform clicks on the current view, if it's shouldn't be block then run the block parameter
 */
@SuppressLint("ClickableViewAccessibility")
fun View.setBlockingClickListener(block: () -> Unit) = this.setOnTouchListener { v, event ->
    if(event.metaState != KeyEvent.META_META_ON) {
        if (event.actionMasked == MotionEvent.ACTION_UP) {
            block()
        }
        return@setOnTouchListener true
    }
    return@setOnTouchListener false
}

/**
 *  Prevent Fullview SDK to perform a click
 */
@SuppressLint("ClickableViewAccessibility")
fun View.blockClickEvent() = this.setOnTouchListener { v, event ->
    if(event.metaState != KeyEvent.META_META_ON) {
        if(event.actionMasked == MotionEvent.ACTION_UP) {
            v.performClick()
        }
        return@setOnTouchListener true
    }
    return@setOnTouchListener false
}

@OptIn(ExperimentalComposeUiApi::class)
@Composable
fun Modifier.blockClickEvent() : Modifier {
    return this then Modifier.pointerInteropFilter {
        if(it.metaState != KeyEvent.META_META_ON) {
            return@pointerInteropFilter false
        }
        return@pointerInteropFilter true
    }
}