package io.fullview.fullview_sdk.services

import android.provider.Settings
import co.daily.model.CallState
import io.fullview.fullview_sdk.DailyState
import io.fullview.fullview_sdk.ui.Highlight
import io.fullview.fullview_sdk.KoinApp


private const val TAG = "ScreenShareService"

class ScreenShareService : ForegroundService(
    notificationChannelId = "channel_screenshare",
    notificationChannelName = "Active screen share",
) {

    private lateinit var drawView : DrawView
    private val hubRepository = KoinApp.getHub()

    override fun onCreate() {
        super.onCreate()

        if(Settings.canDrawOverlays(applicationContext)) {
            drawView = DrawView(applicationContext)
            drawView.open()
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        if(Settings.canDrawOverlays(applicationContext)) {
            drawView.removeOverLay()
        }
    }

    override fun onStateChanged(newState: DailyState) {
        if (newState.status != CallState.joined) {
            stopSelf()
        } else if (!newState.screenShareActive) {
            stopSelf()
        } else {
            if(Settings.canDrawOverlays(applicationContext)) {
                hubRepository.collectorConnection.on("highlight", { pointer ->
                    drawView.updatePointer(pointer)
                }, Highlight::class.java)
            }
        }
    }
}
