package io.fullview.fullview_sdk.ui

import android.content.Context
import android.util.AttributeSet
import android.widget.Checkable
import androidx.appcompat.widget.AppCompatImageButton
import io.fullview.fullview_sdk.R


class ToggleImageButton : AppCompatImageButton, Checkable {
    var onCheckedChangeListener: OnCheckedChangeListener? = null

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        setChecked(attrs)
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        setChecked(attrs)
    }

    private fun setChecked(attrs: AttributeSet) {
        val a = context.obtainStyledAttributes(attrs, R.styleable.ToggleImageButton)
        isChecked = a.getBoolean(R.styleable.ToggleImageButton_android_checked, false)
        a.recycle()
    }

    override fun isChecked(): Boolean {
        return isSelected
    }

    override fun setChecked(checked: Boolean) {
        isSelected = checked

        if (onCheckedChangeListener != null) {
            onCheckedChangeListener!!.onCheckedChanged(this, checked)
        }
    }

    override fun toggle() {
        isChecked = !isChecked
    }

    override fun performClick(): Boolean {
        toggle()
        return super.performClick()
    }

    interface OnCheckedChangeListener {
        fun onCheckedChanged(buttonView: ToggleImageButton?, isChecked: Boolean)
    }
}