package repository

import com.microsoft.signalr.GsonHubProtocol
import com.microsoft.signalr.HubConnection
import com.microsoft.signalr.HubConnectionBuilder
import com.microsoft.signalr.HubConnectionState
import com.microsoft.signalr.TransportEnum
import com.microsoft.signalr.messagepack.MessagePackHubProtocol
import io.fullview.fullview_sdk.Region
import io.reactivex.rxjava3.core.Single
import provideGson


object HubRepository {
    lateinit var accessConnection : HubConnection
    lateinit var collectorConnection : HubConnection

    private val isAccessInitialized get() = this::accessConnection.isInitialized
    val isAccessConnected get() = isAccessInitialized && accessConnection.connectionState == HubConnectionState.CONNECTED

    private val isCollectorInitialized get() = this::collectorConnection.isInitialized
    val isCollectorConnected get() = isCollectorInitialized && collectorConnection.connectionState == HubConnectionState.CONNECTED

    fun createCustomerCollectorConnection(region: Region, accessToken: String, cobrowseId: String) {
        collectorConnection = HubConnectionBuilder.create("https://api.${region.value.lowercase()}.fullview.io/v1/collector/hubs/customerEvents?placementKey=$cobrowseId")
            .shouldSkipNegotiate(true)
            .withHubProtocol(MessagePackHubProtocol())
            .withTransport(TransportEnum.WEBSOCKETS)
            .withAccessTokenProvider(
                Single.defer { Single.just(accessToken) }
            )
            .withHubProtocol(
                GsonHubProtocol(
                    provideGson() // 🎉 This will serialize the CustomerTabStateSourceEvent correctly from an Int to the enum. Remove this when backend is fixed
                )
            )
            .build()
    }


    fun createCustomerAccessConnection(region: Region, accessToken: String) {
        accessConnection = HubConnectionBuilder.create("https://api.${region.value.lowercase()}.fullview.io/access/hubs/customerState")
            .shouldSkipNegotiate(true)
            .withHubProtocol(MessagePackHubProtocol())
            .withTransport(TransportEnum.WEBSOCKETS)
            .withAccessTokenProvider(
                Single.defer { Single.just(accessToken) }
            )
            .withHubProtocol(
                GsonHubProtocol(
                    provideGson() // 🎉 This will serialize the CustomerTabStateSourceEvent correctly from an Int to the enum. Remove this when backend is fixed
                )
            )
            .build()
    }

    fun closeAccess() {
        accessConnection.close()
    }

    fun closeCollector() {
        collectorConnection.close()
    }
}