package io.fullview.fullview_sdk

import android.app.Activity
import android.app.Application
import kotlinx.coroutines.flow.SharedFlow

interface FullviewInterface {
    fun attach(application: Application, hostType: HostType? = HostType.NATIVE)
    fun attach(activity: Activity, hostType: HostType? = HostType.NATIVE)
    fun register(
        organisationId: String,
        userId: String,
        deviceId: String,
        name: String,
        email: String,
        region: Region,
        layout: HubLayout
    )
    fun logout()
    fun requestCoBrowse()
    fun cancelCoBrowseRequest()
    val positionInCoBrowseQueue : SharedFlow<Int>
    val sessionState: SharedFlow<FullviewSessionState>
}