package io.fullview.fullview_sdk

import android.os.Parcelable
import io.fullview.fullview_sdk.data.WebRTCConfig
import kotlinx.parcelize.Parcelize

sealed class FullviewSessionState {
    data object ATTACHED : FullviewSessionState()
    data object IDLE : FullviewSessionState()
    data class CO_BROWSE_INVITATION(
        val id: String,
        val agentName: String,
        val privacyPolicyUrl: String,
        val privacyPolicyText: String?
    ) : FullviewSessionState()

    data class CO_BROWSE_ACTIVE(
        val id: String,
        val agentName: String,
        val webRTCURL: String,
        val webRTCConfig: WebRTCConfig,
    ) : FullviewSessionState()

    data object CO_BROWSE_ENDED : FullviewSessionState()
    data object CO_BROWSE_REQUESTED : FullviewSessionState()

    fun FullviewSessionState?.isActive() = this is CO_BROWSE_ACTIVE
}