package io.fullview.fullview_sdk.helpers

import io.fullview.fullview_sdk.BuildConfig
import io.fullview.fullview_sdk.Region

fun Region.toBaseUrl(path: String? = null) : String =
    when(this) {
        Region.EU1 -> BuildConfig.FULLVIEW_BASE_URL_EU1 + (path ?: "")
        Region.EU2 -> BuildConfig.FULLVIEW_BASE_URL_EU2 + (path ?: "")
        Region.US1 -> BuildConfig.FULLVIEW_BASE_URL_US1 + (path ?: "")
    }

fun Region.toHubBaseUrl() =
    when(this) {
        Region.EU1 -> BuildConfig.FULLVIEW_HUB_BASE_URL_EU1
        Region.EU2 -> BuildConfig.FULLVIEW_HUB_BASE_URL_EU2
        Region.US1 -> BuildConfig.FULLVIEW_HUB_BASE_URL_US1
    }