import com.google.gson.Gson
import com.google.gson.GsonBuilder
import io.fullview.fullview_sdk.BuildConfig
import network.ApiService
import network.adapters.AccessCustomerTabStateSourceEventAdapter
import network.adapters.OffsetDateTimeAdapter
import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import org.koin.dsl.module
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.time.OffsetDateTime
import java.util.concurrent.TimeUnit


fun provideHttpClient(): OkHttpClient {

    val logger = HttpLoggingInterceptor()
    logger.level = HttpLoggingInterceptor.Level.BODY

    return OkHttpClient
        .Builder()
        .readTimeout(60, TimeUnit.SECONDS)
        .connectTimeout(60, TimeUnit.SECONDS)
        .addInterceptor(logger)
        .build()
}

fun provideGson(): Gson = GsonBuilder()
    .registerTypeAdapter(access.models.CustomerTabStateSourceEvent::class.java, AccessCustomerTabStateSourceEventAdapter) // This is to handle faulty signal R enum type
    .registerTypeAdapter(OffsetDateTime::class.java, OffsetDateTimeAdapter)
    .create()



fun provideRetrofit(
    okHttpClient: OkHttpClient,
    gson: Gson
): Retrofit {
    return Retrofit.Builder()
        .baseUrl(BuildConfig.FULLVIEW_BASE_URL)
        .client(okHttpClient)
        .addConverterFactory(GsonConverterFactory.create(gson))
        .build()
}

fun provideApiService(retrofit: Retrofit): ApiService =
    retrofit.create(ApiService::class.java)


val networkModule= module {
    single { provideHttpClient() }
    single { provideGson() }
    single { provideRetrofit(get(),get()) }
    single { provideApiService(get()) }
}