package io.fullview.fullview_sdk

import android.app.Activity
import android.app.Application
import kotlinx.coroutines.flow.SharedFlow

interface FullviewInterface {
    fun attach(application: Application, hostType: HostType? = HostType.NATIVE)
    fun attach(activity: Activity, hostType: HostType? = HostType.NATIVE)
    fun register(
        organisationId: String,
        userId: String,
        deviceId: String,
        name: String,
        email: String,
        region: Region,
        additionalConfig: Map<String, String>? = emptyMap()
    )
    fun logout()
    fun requestCoBrowse()
    fun cancelCoBrowseRequest()
    val positionInCoBrowseQueue : SharedFlow<Int>
    val sessionState: SharedFlow<FullviewSessionState>

    companion object {
        const val LAYOUT = "fullview-layout"
        const val INVITATION = "fullview-invitation-code"
        const val HOST_TYPE = "fullview-host-type"
    }
}