package io.fullview.fullview_sdk.helpers

import android.content.Context
import android.util.AttributeSet
import android.view.SurfaceView
import android.view.View
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import androidx.constraintlayout.widget.ConstraintLayout


open class DataRedactionView(context: Context, attrs: AttributeSet?) : ConstraintLayout(context, attrs) {

    private var surfaceView : SurfaceView = SurfaceView(context)

    init {
        surfaceView.id = View.generateViewId()
        surfaceView.setSecure(true)
        surfaceView.setZOrderOnTop(true)
        surfaceView.isDrawingCacheEnabled = true
        surfaceView.drawingCacheBackgroundColor = resources.getColor(android.R.color.black)
        val params = LayoutParams(MATCH_PARENT, MATCH_PARENT).apply {
            width = this@DataRedactionView.measuredWidth
            height = this@DataRedactionView.measuredHeight
            startToStart = this@DataRedactionView.id
            topToTop = this@DataRedactionView.id
            endToEnd = this@DataRedactionView.id
            bottomToBottom = this@DataRedactionView.id
        }

        surfaceView.layoutParams = params

        this.addView(surfaceView)
    }
}