package io.fullview.fullview_sdk.helpers

import android.graphics.Color
import android.graphics.PorterDuff
import android.util.Log
import android.view.SurfaceView
import timber.log.Timber

object SurfaceViewHelpers {
    fun clear(surfaceView: SurfaceView) {
        if (surfaceView.isLaidOut && surfaceView.isAttachedToWindow && surfaceView.isShown) {
            try {
                val canvas = surfaceView.holder.lockCanvas()
                canvas?.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR)
                surfaceView.holder.unlockCanvasAndPost(canvas)
            } catch (e: Exception) {
                Log.e(this::class.java.simpleName,  "Error clearing buffer position 0", e)
            }
            try {
                val canvas1 = surfaceView.holder.lockCanvas()
                canvas1?.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR)
                surfaceView.holder.unlockCanvasAndPost(canvas1)
            } catch (e: Exception) {
                Log.e(this::class.java.simpleName,  "Error clearing buffer position 1", e)
            }
            try {
                val canvas2 = surfaceView.holder.lockCanvas()
                canvas2?.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR)
                surfaceView.holder.unlockCanvasAndPost(canvas2)
            } catch (e: Exception) {
                Log.e(this::class.java.simpleName, "Error clearing buffer position 2", e)
            }
        }
    }

    fun getDensityCoordinates(x: Int, y: Int, density: Float) : List<Float> {
        val cX = x.toFloat() * density
        val cY = y.toFloat() * density
        return listOf(cX, cY)
    }
}