package io.fullview.fullview_sdk.incoming

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import android.widget.Toast
import androidx.fragment.app.Fragment
import io.fullview.fullview_sdk.R
import timber.log.Timber


private const val ARG_AGENT_NAME = "fullview_agent_name"
private const val ARG_COBROWSE_ID = "fullview_cobrowse_id"
private const val ARG_COBROWSE_CONFIG_PRIVACY_TEXT = "fullview_cobrowse_config_privacy_text"
private const val ARG_COBROWSE_CONFIG_PRIVACY_URL = "fullview_cobrowse_config_privacy_url"

class IncomingCallFragment : Fragment() {

    interface IncomingCallInterface {
        fun declineCall(invitationId: String)
        fun acceptCall(invitationId: String)
    }

    lateinit var agentName: String
    lateinit var id: String
    lateinit var privacyURL: String
    var privacyText: String? = null
    private lateinit var root : View
    private var callback : IncomingCallInterface? = null

    fun setListener(listener : IncomingCallInterface?) {
        callback = listener
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            agentName = it.getString(ARG_AGENT_NAME) ?: "Unknown"
            id = it.getString(ARG_COBROWSE_ID) ?: "-"
            privacyURL = it.getString(ARG_COBROWSE_CONFIG_PRIVACY_URL) ?: "-"
            privacyText = it.getString(ARG_COBROWSE_CONFIG_PRIVACY_TEXT)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        root = inflater.inflate(R.layout.fragment_incoming_call, container, false)
        return root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        root.findViewById<TextView>(R.id.agent_is_calling).text =
            resources.getString(
                R.string.x_is_trying_to_call_you,
                agentName
            )

        root.findViewById<Button>(R.id.accept).setOnClickListener {
            callback?.acceptCall(id)
        }

        root.findViewById<Button>(R.id.decline).setOnClickListener {
            callback?.declineCall(id)
        }

        root.findViewById<TextView>(R.id.privacy_policy).text = privacyText ?: resources.getString(R.string.for_more_information_on_the_data_used_during_a_cobrowse_please_take_a_look_at_the_privacy_policy)
        root.findViewById<TextView>(R.id.privacy_policy_link).setOnClickListener {
            var url = privacyURL
            if (url.startsWith("https://").not() && url.startsWith("http://").not()){
                url = "http://$url"
            }
            try {
                startActivity(Intent(Intent.ACTION_VIEW, Uri.parse(url)))
            } catch (e: Exception) {
                Log.e(this::class.java.simpleName, "No application found to open url", e)
                Toast.makeText(context, "No application found to open url", Toast.LENGTH_LONG).show()
            }
        }
    }

    companion object {
        @JvmStatic
        fun newInstance(invitationId: String, agentName: String, privacyURL: String, customPrivacyText: String?) = IncomingCallFragment().apply {
            arguments = Bundle().apply {
                putString(ARG_AGENT_NAME, agentName)
                putString(ARG_COBROWSE_ID, invitationId)
                putString(ARG_COBROWSE_CONFIG_PRIVACY_URL, privacyURL)
                putString(ARG_COBROWSE_CONFIG_PRIVACY_TEXT, customPrivacyText)
            }
        }
    }
}