package io.fullview.fullview_sdk.ongoing

import androidx.lifecycle.ViewModel
import io.fullview.fullview_sdk.DailyState
import io.fullview.fullview_sdk.KoinApp
import io.fullview.fullview_sdk.data.HubCoordinates
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.update
import kotlin.time.Duration

class OngoingCallViewModel : ViewModel() {

    private val sessionRepository = KoinApp.getSessionRepository()
    val startOfCall = sessionRepository.startOfCall
    val hubCoordinates = sessionRepository.hubCoordinates

    private val _dailyState = MutableStateFlow<DailyState?>(null)
    val dailyState = _dailyState.asStateFlow()

    private val _touchTimestamp = MutableStateFlow(System.currentTimeMillis())
    val touchTimestamp = _touchTimestamp.asStateFlow()

    fun tickerFlow(period: Duration, initialDelay: Duration = Duration.ZERO) = flow {
        delay(initialDelay)
        while (true) {
            emit(Unit)
            delay(period)
        }
    }

    fun updateHubCoordinates(x: Float, y: Float, portrait: Boolean) {
        sessionRepository.updateHubPosition(HubCoordinates(x, y, portrait))
    }

    fun updateOrientation(orientation: Int) {
        sessionRepository.updateOrientation(orientation)
    }

    fun setStart() {
        sessionRepository.setStart()
    }

    fun clearStart() {
        sessionRepository.clearStart()
    }

    fun setTouchTimestamp(timestamp: Long) {
        _touchTimestamp.update { timestamp }
    }

    fun setDailyState(state: DailyState) {
        _dailyState.update { state }
    }
}