package network

import access.models.AcceptCoBrowse
import access.models.AcceptCoBrowseResponse
import access.models.CoBrowseUpdateParticipant
import access.models.DeclineCoBrowse
import access.models.OrganisationSDKConfig
import access.models.RegisterCustomer
import access.models.RegisterCustomerResponse
import access.models.SupportRequest
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.POST
import retrofit2.http.Url

interface ApiService {

    /**
     * Access calls
     */
    @POST
    suspend fun registerCustomer(
        @Url url: String,
        @Body registerRequest: RegisterCustomer
    ): RegisterCustomerResponse


    @GET
    suspend fun getOrganisationConfig(
        @Url url: String
    ) : OrganisationSDKConfig

    @POST
    suspend fun endCoBrowse(
        @Url url: String,
        @Header("Authorization") auth: String,
    )

    @POST
    suspend fun acceptCoBrowse(
        @Url url: String,
        @Body acceptCoBrowse: AcceptCoBrowse,
        @Header("Authorization") auth: String,
    ) : AcceptCoBrowseResponse

    @POST
    suspend fun declineCobrowse(
        @Url url: String,
        @Body acceptCoBrowse: DeclineCoBrowse,
        @Header("Authorization") auth: String,
    )

    @POST
    suspend fun requestCoBrowse(
        @Url url: String,
        @Header("Authorization") auth: String,
        @Body requestSupport: SupportRequest
    )

    @POST
    suspend fun cancelCoBrowseRequest(
        @Url url: String,
        @Header("Authorization") auth: String,
    )

    @POST
    suspend fun updateParticipant(
        @Url url: String,
        @Body participant: CoBrowseUpdateParticipant,
        @Header("Authorization") auth: String,
    )
}