package network.adapters

import access.models.CustomerTabStateSourceEvent
import com.google.gson.TypeAdapter
import com.google.gson.stream.JsonReader
import com.google.gson.stream.JsonToken
import com.google.gson.stream.JsonWriter
import java.io.IOException

object AccessCustomerTabStateSourceEventAdapter : TypeAdapter<CustomerTabStateSourceEvent?>() {
    @Throws(IOException::class)
    override fun write(out: JsonWriter, value: CustomerTabStateSourceEvent?) {
        out.value(when(value) {
            CustomerTabStateSourceEvent.TabSwitch -> 1
            CustomerTabStateSourceEvent.TabOpen -> 2
            CustomerTabStateSourceEvent.TabReconnect -> 3
            CustomerTabStateSourceEvent.TabRefresh -> 4
            CustomerTabStateSourceEvent.TabDisconnect -> 5
            CustomerTabStateSourceEvent.TabBecameActive -> 6
            CustomerTabStateSourceEvent.TabBecameInactive -> 7
            CustomerTabStateSourceEvent.TabPageChanged -> 8
            CustomerTabStateSourceEvent.AgentConnected -> 9
            CustomerTabStateSourceEvent.AgentDisconnected -> 10
            CustomerTabStateSourceEvent.CustomerConnected -> 11
            CustomerTabStateSourceEvent.CustomerDisconnected -> 12
            CustomerTabStateSourceEvent.ParticipantUpdated -> 13
            CustomerTabStateSourceEvent.CoBrowseInvitation -> 100
            CustomerTabStateSourceEvent.CoBrowseInvitationDeclined -> 101
            CustomerTabStateSourceEvent.CoBrowseInvitationAccepted -> 102
            CustomerTabStateSourceEvent.CoBrowseEnded -> 103
            CustomerTabStateSourceEvent.SupportRequestPositionUpdated -> 104
            CustomerTabStateSourceEvent.SessionStopped -> 200
            CustomerTabStateSourceEvent.MeetingInvitationReceived -> 300
            CustomerTabStateSourceEvent.MeetingInvitationDeclined -> 301
            CustomerTabStateSourceEvent.MeetingInvitationAccepted -> 302
            CustomerTabStateSourceEvent.MeetingLeft -> 303
            CustomerTabStateSourceEvent.MeetingUpdated -> 304
            else -> null
        })
    }

    @Throws(IOException::class)
    override fun read(`in`: JsonReader): CustomerTabStateSourceEvent? {
        if (`in`.peek() === JsonToken.NULL) {
            `in`.nextNull()
            return null
        }

        val nextValue = `in`.nextInt()

        return when(nextValue) {
            1 -> CustomerTabStateSourceEvent.TabSwitch
            2 -> CustomerTabStateSourceEvent.TabOpen
            3 -> CustomerTabStateSourceEvent.TabReconnect
            4 -> CustomerTabStateSourceEvent.TabRefresh
            5 -> CustomerTabStateSourceEvent.TabDisconnect
            6 -> CustomerTabStateSourceEvent.TabBecameActive
            7 -> CustomerTabStateSourceEvent.TabBecameInactive
            8 -> CustomerTabStateSourceEvent.TabPageChanged
            9 -> CustomerTabStateSourceEvent.AgentConnected
            10 -> CustomerTabStateSourceEvent.AgentDisconnected
            11 -> CustomerTabStateSourceEvent.CustomerConnected
            12 -> CustomerTabStateSourceEvent.CustomerDisconnected
            13 -> CustomerTabStateSourceEvent.ParticipantUpdated
            100 -> CustomerTabStateSourceEvent.CoBrowseInvitation
            101 -> CustomerTabStateSourceEvent.CoBrowseInvitationDeclined
            102 -> CustomerTabStateSourceEvent.CoBrowseInvitationAccepted
            103 -> CustomerTabStateSourceEvent.CoBrowseEnded
            104 -> CustomerTabStateSourceEvent.SupportRequestPositionUpdated
            200 -> CustomerTabStateSourceEvent.SessionStopped
            300 -> CustomerTabStateSourceEvent.MeetingInvitationReceived
            301 -> CustomerTabStateSourceEvent.MeetingInvitationDeclined
            302 -> CustomerTabStateSourceEvent.MeetingInvitationAccepted
            303 -> CustomerTabStateSourceEvent.MeetingLeft
            304 -> CustomerTabStateSourceEvent.MeetingUpdated
            else -> null
        }
    }
}