package network.models

import android.os.Parcelable
import androidx.annotation.Keep
import kotlinx.parcelize.Parcelize

@Parcelize
@Keep
data class RRWebMeta(
    val type: Int,
    val data: RRWebData,
    val timestamp: Long
) : Parcelable {

    @Parcelize
    @Keep
    data class RRWebData(
        val href: String,
        val width: Int,
        val height: Int
    ) : Parcelable
}