/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwks;

import io.fusionauth.jwks.JSONWebKeyParserException;
import io.fusionauth.jwks.JWKUtils;
import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.domain.KeyType;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Objects;

public class JSONWebKeyParser {
    public PublicKey parse(JSONWebKey key) {
        Objects.requireNonNull(key);
        try {
            if (key.kty == KeyType.RSA) {
                BigInteger modulus = JWKUtils.base64DecodeUint(key.n);
                BigInteger publicExponent = JWKUtils.base64DecodeUint(key.e);
                return KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(modulus, publicExponent));
            }
            if (key.kty == KeyType.EC) {
                AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
                switch (key.crv) {
                    case "P-256": {
                        parameters.init(new ECGenParameterSpec("secp256r1"));
                        break;
                    }
                    case "P-384": {
                        parameters.init(new ECGenParameterSpec("secp384r1"));
                        break;
                    }
                    case "P-521": {
                        parameters.init(new ECGenParameterSpec("secp521r1"));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported EC algorithm. Support algorithms include P-256, P-384 and P-521.");
                    }
                }
                ECParameterSpec ecParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
                BigInteger x = JWKUtils.base64DecodeUint(key.x);
                BigInteger y = JWKUtils.base64DecodeUint(key.y);
                ECPoint ecPoint = new ECPoint(x, y);
                return KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(ecPoint, ecParameterSpec));
            }
        }
        catch (Exception e) {
            throw new JSONWebKeyParserException("Failed to parse the provided JSON Web Key", e);
        }
        throw new UnsupportedOperationException("Only RSA or EC JSON Web Keys may be parsed.");
    }
}

