/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.json.Mapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Header {
    @JsonProperty(value="alg")
    public Algorithm algorithm;
    @JsonIgnore
    public Map<String, Object> properties = new LinkedHashMap<String, Object>();
    @JsonProperty(value="typ")
    public String type = "JWT";

    public Header() {
    }

    public Header(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @JsonAnyGetter
    public Map<String, Object> anyGetter() {
        return this.properties;
    }

    public String getString(String name) {
        Object result = this.properties.get(name);
        return result != null ? result.toString() : null;
    }

    public Object get(String name) {
        return this.properties.get(name);
    }

    @JsonAnySetter
    public Header set(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        this.properties.put(name, value);
        return this;
    }

    public String toString() {
        return new String(Mapper.prettyPrint(this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return this.algorithm == header.algorithm && Objects.equals(this.properties, header.properties) && Objects.equals(this.type, header.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.properties, this.type});
    }
}

