/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.body.request;

import io.fusionauth.http.ParseException;
import io.fusionauth.http.util.HTTPTools;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ChunkedBodyState {
    ChunkSize{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            if (ch == 13) {
                return ChunkSizeCR;
            }
            if (HTTPTools.isHexadecimalCharacter(ch)) {
                return ChunkSize;
            }
            throw new ParseException();
        }
    }
    ,
    ChunkSizeCR{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            if (ch == 10) {
                return ChunkSizeLF;
            }
            throw new ParseException();
        }
    }
    ,
    ChunkSizeLF{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            return Chunk;
        }
    }
    ,
    Chunk{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            if (bytesRead < length) {
                return Chunk;
            }
            if (bytesRead == length && ch == 13) {
                return ChunkCR;
            }
            throw new ParseException();
        }
    }
    ,
    ChunkCR{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            if (ch == 10) {
                return length == 0L ? Complete : ChunkLF;
            }
            throw new ParseException();
        }
    }
    ,
    ChunkLF{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            if (length == 0L) {
                return Complete;
            }
            if (HTTPTools.isHexadecimalCharacter(ch)) {
                return ChunkSize;
            }
            throw new ParseException();
        }
    }
    ,
    Complete{

        @Override
        public ChunkedBodyState next(byte ch, long length, long bytesRead) {
            return null;
        }
    };


    public abstract ChunkedBodyState next(byte var1, long var2, long var4);
}

