/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;

public class ReaderBlockingByteBufferInputStream
extends InputStream
implements Consumer<ByteBuffer> {
    private static final ByteBuffer Last = ByteBuffer.allocate(0);
    private final BlockingQueue<ByteBuffer> buffers = new LinkedBlockingQueue<ByteBuffer>();
    private ByteBuffer currentBuffer;

    @Override
    public void accept(ByteBuffer buffer) {
        if (!this.buffers.offer(buffer)) {
            throw new IllegalStateException("The LinkedBlockingQueue is borked. It should never reject an offer() operation.");
        }
    }

    @Override
    public int read() {
        this.poll();
        if (this.currentBuffer == Last) {
            return -1;
        }
        return this.currentBuffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) {
        this.poll();
        if (this.currentBuffer == Last) {
            return -1;
        }
        int length = Math.min(len, this.currentBuffer.remaining());
        this.currentBuffer.get(b, off, length);
        return length;
    }

    public void signalDone() {
        this.accept(Last);
    }

    private void poll() {
        while (!(this.currentBuffer == Last || this.currentBuffer != null && this.currentBuffer.hasRemaining())) {
            try {
                this.currentBuffer = this.buffers.take();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

