/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.server.Instrumenter;

public class CountingInstrumenter
implements Instrumenter {
    private long badRequests;
    private long bytesRead;
    private long bytesWritten;
    private long chunkedRequests;
    private long chunkedResponses;
    private long closedConnections;
    private long connections;
    private long startedCount;

    @Override
    public void acceptedConnection() {
        ++this.connections;
    }

    @Override
    public void badRequest() {
        ++this.badRequests;
    }

    @Override
    public void chunkedRequest() {
        ++this.chunkedRequests;
    }

    @Override
    public void chunkedResponse() {
        ++this.chunkedResponses;
    }

    @Override
    public void connectionClosed() {
        ++this.closedConnections;
    }

    public long getBadRequests() {
        return this.badRequests;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public long getChunkedRequests() {
        return this.chunkedRequests;
    }

    public long getChunkedResponses() {
        return this.chunkedResponses;
    }

    public long getClosedConnections() {
        return this.closedConnections;
    }

    public long getConnections() {
        return this.connections;
    }

    public long getStartedCount() {
        return this.startedCount;
    }

    @Override
    public void readFromClient(long bytes) {
        this.bytesRead += bytes;
    }

    @Override
    public void serverStarted() {
        ++this.startedCount;
    }

    @Override
    public void wroteToClient(long bytes) {
        this.bytesWritten += bytes;
    }
}

