/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.body.request.BodyProcessor;
import io.fusionauth.http.body.request.ChunkedBodyProcessor;
import io.fusionauth.http.body.request.ContentLengthBodyProcessor;
import io.fusionauth.http.io.ReaderBlockingByteBufferInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.Instrumenter;
import io.fusionauth.http.server.RequestPreambleState;
import io.fusionauth.http.server.RequestState;
import java.nio.ByteBuffer;

public class HTTPRequestProcessor {
    private final int bufferSize;
    private final StringBuilder builder = new StringBuilder();
    private final HTTPServerConfiguration configuration;
    private final Logger logger;
    private final HTTPRequest request;
    private BodyProcessor bodyProcessor;
    private String headerName;
    private ReaderBlockingByteBufferInputStream inputStream;
    private RequestPreambleState preambleState = RequestPreambleState.RequestMethod;
    private RequestState state = RequestState.Preamble;

    public HTTPRequestProcessor(HTTPServerConfiguration configuration, HTTPRequest request) {
        this.bufferSize = configuration.getRequestBufferSize();
        this.configuration = configuration;
        this.request = request;
        this.logger = configuration.getLoggerFactory().getLogger(HTTPRequestProcessor.class);
    }

    public ByteBuffer bodyBuffer() {
        return this.bodyProcessor.currentBuffer();
    }

    public RequestState processBodyBytes() {
        this.bodyProcessor.processBuffer(this.inputStream);
        if (this.bodyProcessor.isComplete()) {
            this.inputStream.signalDone();
            return RequestState.Complete;
        }
        return RequestState.Body;
    }

    public RequestState processPreambleBytes(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            byte ch = buffer.get();
            RequestPreambleState nextState = this.preambleState.next(ch);
            if (nextState != this.preambleState) {
                switch (this.preambleState) {
                    case RequestMethod: {
                        this.request.setMethod(HTTPMethod.of(this.builder.toString()));
                        break;
                    }
                    case RequestPath: {
                        this.request.setPath(this.builder.toString());
                        break;
                    }
                    case RequestProtocol: {
                        this.request.setProtocol(this.builder.toString());
                        break;
                    }
                    case HeaderName: {
                        this.headerName = this.builder.toString();
                        break;
                    }
                    case HeaderValue: {
                        this.request.addHeader(this.headerName, this.builder.toString());
                    }
                }
                if (nextState.store()) {
                    this.builder.delete(0, this.builder.length());
                    this.builder.appendCodePoint(ch);
                }
            } else if (this.preambleState.store()) {
                this.builder.appendCodePoint(ch);
            }
            this.preambleState = nextState;
            if (this.preambleState != RequestPreambleState.Complete) continue;
            this.logger.debug("Preamble successfully parsed");
            Long contentLength = this.request.getContentLength();
            if (contentLength != null && contentLength > 0L || this.request.isChunked()) {
                this.logger.debug("Client indicated it was sending an entity-body in the request");
                this.state = RequestState.Body;
                int size = Math.max(buffer.remaining(), this.bufferSize);
                if (contentLength != null) {
                    this.logger.debug("Handling body using Content-Length header");
                    this.bodyProcessor = new ContentLengthBodyProcessor(size, contentLength);
                } else {
                    this.logger.debug("Handling body using Chunked data");
                    this.bodyProcessor = new ChunkedBodyProcessor(size);
                    Instrumenter instrumenter = this.configuration.getInstrumenter();
                    if (instrumenter != null) {
                        instrumenter.chunkedRequest();
                    }
                }
                this.inputStream = new ReaderBlockingByteBufferInputStream();
                if (buffer.hasRemaining()) {
                    ByteBuffer bodyBuffer = this.bodyProcessor.currentBuffer();
                    bodyBuffer.put(buffer);
                    bodyBuffer.flip();
                    this.state = this.processBodyBytes();
                }
                this.request.setInputStream(this.inputStream);
            } else {
                this.logger.debug("Client indicated it was NOT sending an entity-body in the request");
                this.state = RequestState.Complete;
            }
            if (!"100-continue".equalsIgnoreCase(this.request.getHeader("Expect"))) continue;
            this.logger.debug("Expect request received");
            this.state = RequestState.Expect;
            return this.state;
        }
        return this.state;
    }

    public void resetState(RequestState state) {
        this.state = state;
    }

    public RequestState state() {
        return this.state;
    }
}

