/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.io.DelegatingOutputStream;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.util.HTTPTools;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HTTPResponse {
    private final Map<String, Map<String, Cookie>> cookies = new HashMap<String, Map<String, Cookie>>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final DelegatingOutputStream outputStream;
    private volatile boolean committed;
    private Throwable exception;
    private int status = 200;
    private String statusMessage;
    private Writer writer;

    public HTTPResponse(OutputStream outputStream, HTTPRequest request, boolean compressByDefault) {
        this.outputStream = new DelegatingOutputStream(request, this, outputStream, compressByDefault);
    }

    public HTTPResponse(OutputStream outputStream, HTTPRequest request) {
        this(outputStream, request, true);
    }

    public void addCookie(Cookie cookie) {
        String path = cookie.path != null ? cookie.path : "/";
        this.cookies.computeIfAbsent(path, key -> new HashMap()).put(cookie.name, cookie);
    }

    public void addHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.headers.computeIfAbsent(name.toLowerCase(), key -> new ArrayList()).add(value);
    }

    public void clearHeaders() {
        this.headers.clear();
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.outputStream.close();
        }
    }

    public boolean containsHeader(String name) {
        String key = name.toLowerCase();
        return this.headers.containsKey(key) && this.headers.get(key).size() > 0;
    }

    public boolean failure() {
        return this.status < 200 || this.status > 299;
    }

    public Charset getCharset() {
        HTTPTools.HeaderValue headerValue;
        String charsetName;
        Charset charset = StandardCharsets.UTF_8;
        String contentType = this.getContentType();
        if (contentType != null && (charsetName = (headerValue = HTTPTools.parseHeaderValue(contentType)).parameters().get("charset")) != null) {
            charset = Charset.forName(charsetName);
        }
        return charset;
    }

    public Long getContentLength() {
        if (this.containsHeader("Content-Length")) {
            return Long.parseLong(this.getHeader("Content-Length"));
        }
        return null;
    }

    public void setContentLength(long length) {
        this.setHeader("Content-Length", Long.toString(length));
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public List<Cookie> getCookies() {
        return this.cookies.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public String getHeader(String name) {
        String key = name.toLowerCase();
        return this.headers.containsKey(key) && this.headers.get(key).size() > 0 ? this.headers.get(key).get(0) : null;
    }

    public List<String> getHeaders(String key) {
        return this.headers.get(key.toLowerCase());
    }

    public Map<String, List<String>> getHeadersMap() {
        return this.headers;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public String getRedirect() {
        return this.getHeader("Location");
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public Writer getWriter() {
        Charset charset = this.getCharset();
        if (this.writer == null) {
            this.writer = new OutputStreamWriter(this.getOutputStream(), charset);
        }
        return this.writer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCompress() {
        return this.outputStream.isCompress();
    }

    public void setCompress(boolean compress) {
        this.outputStream.setCompress(compress);
    }

    public boolean isKeepAlive() {
        String value = this.getHeader("Connection");
        return value == null || value.equalsIgnoreCase("keep-alive");
    }

    public void removeCookie(String name) {
        this.cookies.values().forEach(map -> map.remove(name));
    }

    public void removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.toLowerCase());
        }
    }

    public void sendRedirect(String uri) {
        this.setHeader("Location", uri);
        this.status = 302;
    }

    public void setDateHeader(String name, ZonedDateTime value) {
        this.addHeader(name, DateTimeFormatter.RFC_1123_DATE_TIME.format(value));
    }

    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.headers.put(name.toLowerCase(), new ArrayList<String>(List.of(value)));
    }

    public boolean willCompress() {
        return this.outputStream.willCompress();
    }
}

