/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.io.ByteBufferOutputStream;
import io.fusionauth.http.server.HTTPResponse;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class HTTPTools {
    public static ByteBuffer buildExpectResponsePreamble(HTTPResponse response, int maxLength) {
        ByteBufferOutputStream bbos = new ByteBufferOutputStream(1024, maxLength);
        HTTPTools.writeStatusLine(response, bbos);
        if (response.getStatus() != 100) {
            bbos.write("Content-Length: 0".getBytes());
            bbos.write(HTTPValues.ControlBytes.CRLF);
            bbos.write("Connection: close".getBytes());
            bbos.write(HTTPValues.ControlBytes.CRLF);
        }
        bbos.write(HTTPValues.ControlBytes.CRLF);
        return bbos.toByteBuffer();
    }

    public static ByteBuffer buildResponsePreamble(HTTPResponse response, int maxLength) {
        ByteBufferOutputStream bbos = new ByteBufferOutputStream(1024, maxLength);
        HTTPTools.writeStatusLine(response, bbos);
        response.getHeadersMap().forEach((key, values) -> values.forEach(value -> {
            bbos.write(key.getBytes());
            bbos.write(58);
            bbos.write(32);
            bbos.write(value.getBytes());
            bbos.write(HTTPValues.ControlBytes.CRLF);
        }));
        bbos.write(HTTPValues.ControlBytes.CRLF);
        return bbos.toByteBuffer();
    }

    public static boolean isDigitCharacter(byte ch) {
        return ch >= 48 && ch <= 57;
    }

    public static boolean isHexadecimalCharacter(byte ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    public static boolean isTokenCharacter(byte ch) {
        return ch == 33 || ch == 35 || ch == 36 || ch == 37 || ch == 38 || ch == 39 || ch == 42 || ch == 43 || ch == 45 || ch == 46 || ch == 94 || ch == 95 || ch == 96 || ch == 124 || ch == 126 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57;
    }

    public static boolean isURICharacter(byte ch) {
        return ch >= 33 && ch <= 126;
    }

    public static boolean isValueCharacter(byte ch) {
        return HTTPTools.isURICharacter(ch) || ch == 32 || ch == 9 || ch == 10;
    }

    public static void parseEncodedData(byte[] data, int start, int length, Map<String, List<String>> result) {
        String value;
        boolean inName = true;
        String name = null;
        for (int i = start; i < length; ++i) {
            if (data[i] == 61 && inName) {
                if (i == start) {
                    ++start;
                    continue;
                }
                inName = false;
                try {
                    name = URLDecoder.decode(new String(data, start, i - start), StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    name = null;
                }
                start = i + 1;
                continue;
            }
            if (data[i] != 38 || inName) continue;
            inName = true;
            if (name == null || start > i) continue;
            try {
                value = start < i ? URLDecoder.decode(new String(data, start, i - start), StandardCharsets.UTF_8) : "";
                result.computeIfAbsent(name, key -> new LinkedList()).add(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            start = i + 1;
            name = null;
        }
        if (name != null && !inName) {
            try {
                value = start < length ? URLDecoder.decode(new String(data, start, length - start), StandardCharsets.UTF_8) : "";
                result.computeIfAbsent(name, key -> new LinkedList()).add(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HeaderValue parseHeaderValue(String value) {
        String headerValue = null;
        Map<String, String> parameters = null;
        char[] chars = value.toCharArray();
        boolean inQuote = false;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!inQuote && c == ';') {
                if (headerValue == null) {
                    headerValue = new String(chars, start, i - start);
                } else {
                    if (parameters == null) {
                        parameters = new HashMap<String, String>();
                    }
                    HTTPTools.parseHeaderParameter(chars, start, i, parameters);
                }
                start = -1;
                continue;
            }
            if (!inQuote && !Character.isWhitespace(c) && start == -1) {
                start = i;
                continue;
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote && c == '\\' && i < chars.length - 2 && chars[i + 1] == '\"') {
                ++i;
                continue;
            }
            if (!inQuote || c != '\"') continue;
            inQuote = false;
        }
        if (start != -1) {
            if (headerValue == null) {
                headerValue = new String(chars, start, chars.length - start);
            } else {
                if (parameters == null) {
                    parameters = new HashMap();
                }
                HTTPTools.parseHeaderParameter(chars, start, chars.length, parameters);
            }
        }
        if (headerValue == null) {
            throw new ParseException("Unable to parse a parameterized HTTP header [" + value + "]");
        }
        if (parameters == null) {
            parameters = Map.of();
        }
        return new HeaderValue(headerValue, parameters);
    }

    private static void parseHeaderParameter(char[] chars, int start, int end, Map<String, String> parameters) {
        boolean encoded = false;
        Charset charset = null;
        String name = null;
        for (int i = start; i < end; ++i) {
            if (name == null && chars[i] == '*') {
                encoded = true;
                name = new String(chars, start, i - start).toLowerCase();
                start = i + 2;
                continue;
            }
            if (name == null && chars[i] == '=') {
                name = new String(chars, start, i - start).toLowerCase();
                start = i + 1;
                continue;
            }
            if (name != null && encoded && charset == null && chars[i] == '\'') {
                String charsetName = new String(chars, start, i - start);
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException e) {
                    charset = StandardCharsets.UTF_8;
                }
                start = i + 1;
                continue;
            }
            if (name == null || !encoded || charset == null || chars[i] != '\'') continue;
            start = i + 1;
        }
        if (start >= end) {
            if (name != null) {
                parameters.put(name, "");
            }
            return;
        }
        if (chars[start] == '\"') {
            ++start;
        }
        if (chars[end - 1] == '\"') {
            --end;
        }
        String encodedValue = new String(chars, start, end - start);
        String value = charset != null ? URLDecoder.decode(encodedValue, charset) : URLDecoder.decode(encodedValue, StandardCharsets.UTF_8);
        if (name == null) {
            name = value;
            value = "";
        }
        if (!parameters.containsKey(name) || encoded) {
            parameters.put(name, value);
        }
    }

    private static void writeStatusLine(HTTPResponse response, ByteBufferOutputStream out) {
        out.write(HTTPValues.ProtocolBytes.HTTTP1_1);
        out.write(32);
        out.write(Integer.toString(response.getStatus()).getBytes());
        out.write(32);
        if (response.getStatusMessage() != null) {
            out.write(response.getStatusMessage().getBytes());
        }
        out.write(HTTPValues.ControlBytes.CRLF);
    }

    public record HeaderValue(String value, Map<String, String> parameters) {
    }
}

