/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class HTTPMethod {
    public static final HTTPMethod CONNECT = new HTTPMethod("CONNECT");
    public static final HTTPMethod DELETE = new HTTPMethod("DELETE");
    public static final HTTPMethod GET = new HTTPMethod("GET");
    public static final HTTPMethod HEAD = new HTTPMethod("HEAD");
    public static final HTTPMethod OPTIONS = new HTTPMethod("OPTIONS");
    public static final HTTPMethod PATCH = new HTTPMethod("PATCH");
    public static final HTTPMethod POST = new HTTPMethod("POST");
    public static final HTTPMethod PUT = new HTTPMethod("PUT");
    public static final HTTPMethod TRACE = new HTTPMethod("TRACE");
    public static Map<String, HTTPMethod> StandardMethods = new HashMap<String, HTTPMethod>();
    private final String name;

    private HTTPMethod(String name) {
        Objects.requireNonNull(name);
        this.name = name.toUpperCase(Locale.ROOT);
    }

    public static HTTPMethod of(String name) {
        HTTPMethod method = StandardMethods.get(name = name.toUpperCase(Locale.ROOT));
        if (method == null) {
            method = new HTTPMethod(name);
        }
        return method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HTTPMethod)) {
            return false;
        }
        HTTPMethod that = (HTTPMethod)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean is(HTTPMethod method) {
        return this == method || this.equals(method);
    }

    public boolean is(String method) {
        return this.name.equals(method);
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        StandardMethods.put(CONNECT.name(), CONNECT);
        StandardMethods.put(DELETE.name(), DELETE);
        StandardMethods.put(GET.name(), GET);
        StandardMethods.put(HEAD.name(), HEAD);
        StandardMethods.put(OPTIONS.name(), OPTIONS);
        StandardMethods.put(PATCH.name(), PATCH);
        StandardMethods.put(POST.name(), POST);
        StandardMethods.put(PUT.name(), PUT);
        StandardMethods.put(TRACE.name(), TRACE);
    }
}

