/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.body.request;

import io.fusionauth.http.body.ChunkException;
import io.fusionauth.http.body.request.BodyProcessor;
import io.fusionauth.http.body.request.ChunkedBodyState;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public class ChunkedBodyProcessor
implements BodyProcessor {
    public static final int MaxChunkSize = 0x7FFFFFFD;
    private final ByteBuffer buffer;
    private final StringBuilder headerSizeHex = new StringBuilder();
    private int chunkBytes;
    private int chunkSize;
    private ChunkedBodyState state = ChunkedBodyState.ChunkSize;
    private int totalBytes;

    public ChunkedBodyProcessor(int bufferSize) {
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public ByteBuffer currentBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isComplete() {
        return this.state == ChunkedBodyState.Complete;
    }

    @Override
    public void processBuffer(Consumer<ByteBuffer> consumer) {
        while (this.buffer.hasRemaining()) {
            byte ch = this.buffer.get();
            ChunkedBodyState nextState = this.state.next(ch, this.chunkSize, this.chunkBytes);
            if (nextState == ChunkedBodyState.Complete) {
                this.state = nextState;
                return;
            }
            if (nextState == ChunkedBodyState.ChunkSize) {
                this.headerSizeHex.appendCodePoint(ch);
            } else if (this.state != ChunkedBodyState.Chunk && nextState == ChunkedBodyState.Chunk) {
                if (this.headerSizeHex.isEmpty()) {
                    throw new ChunkException("Chunk size is missing");
                }
                long chunkSizeLong = Long.parseLong(this.headerSizeHex, 0, this.headerSizeHex.length(), 16);
                if (chunkSizeLong > 0x7FFFFFFDL) {
                    throw new ChunkException("Chunk size too large [" + this.chunkSize + "]. Max chunk size is [2147483645]");
                }
                this.chunkBytes = 0;
                this.chunkSize = (int)chunkSizeLong;
                this.headerSizeHex.delete(0, this.headerSizeHex.length());
                this.buffer.position(this.buffer.position() - 1);
                if (this.chunkSize > 0) {
                    this.offerChunk(consumer);
                }
            } else if (nextState == ChunkedBodyState.Chunk) {
                this.buffer.position(this.buffer.position() - 1);
                if (this.chunkSize > 0) {
                    this.offerChunk(consumer);
                }
            }
            this.state = nextState;
        }
        this.buffer.clear();
    }

    @Override
    public long totalBytesProcessed() {
        return this.totalBytes;
    }

    private void offerChunk(Consumer<ByteBuffer> consumer) {
        int bytes = Math.min(this.chunkSize - this.chunkBytes, this.buffer.remaining());
        ByteBuffer toSend = ByteBuffer.allocate(bytes);
        toSend.put(0, this.buffer, this.buffer.position(), bytes);
        consumer.accept(toSend);
        this.chunkBytes += bytes;
        this.totalBytes += bytes;
        this.buffer.position(this.buffer.position() + bytes);
    }
}

