/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.body.request;

import io.fusionauth.http.body.request.BodyProcessor;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public class ContentLengthBodyProcessor
implements BodyProcessor {
    private final int bufferSize;
    private final long contentLength;
    private ByteBuffer buffer;
    private long bytesRead = 0L;

    public ContentLengthBodyProcessor(int bufferSize, long contentLength) {
        this.bufferSize = bufferSize;
        this.contentLength = contentLength;
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public ByteBuffer currentBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isComplete() {
        return this.bytesRead == this.contentLength;
    }

    @Override
    public void processBuffer(Consumer<ByteBuffer> consumer) {
        if ((long)this.buffer.remaining() + this.bytesRead >= this.contentLength || this.buffer.remaining() == this.buffer.capacity()) {
            this.bytesRead += (long)this.buffer.remaining();
            consumer.accept(this.buffer);
            if (this.bytesRead < this.contentLength) {
                this.buffer = ByteBuffer.allocate(this.bufferSize);
            }
        } else {
            this.buffer.position(this.buffer.limit());
            this.buffer.limit(this.buffer.capacity());
        }
    }

    @Override
    public long totalBytesProcessed() {
        return this.bytesRead;
    }
}

