/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.client;

import io.fusionauth.http.client.ResponseParserState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class HTTPData {
    public static final int BufferSize = 1024;
    public final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    public final StringBuilder builder = new StringBuilder();
    public final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    public int bodyBytes;
    public int bodyLength;
    public int bodyOffset;
    public int code;
    public CompletableFuture<Integer> future;
    public boolean hasBody;
    public String headerName;
    public String host;
    public long lastUsed;
    public String message;
    public int offset;
    public String protocl;
    public ByteBuffer request;
    public ResponseParserState state = ResponseParserState.ResponseProtocol;

    public ByteBuffer currentBuffer() {
        Buffer last;
        Buffer buffer = last = this.buffers.isEmpty() ? null : this.buffers.get(this.buffers.size() - 1);
        if (last == null || last.position() == last.limit()) {
            last = ByteBuffer.allocate(1024);
            this.buffers.add((ByteBuffer)last);
        }
        return last;
    }

    public boolean isResponseComplete() {
        int index = this.offset / 1024;
        ByteBuffer buffer = this.buffers.get(index);
        byte[] array = buffer.array();
        for (int i = 0; i < buffer.position(); ++i) {
            if (this.hasBody) {
                ++this.bodyBytes;
                ++this.offset;
                if (this.bodyBytes != this.bodyLength) continue;
                return true;
            }
            ResponseParserState nextState = this.state.next(array[i], this.headers);
            if (nextState != this.state) {
                switch (this.state) {
                    case ResponseStatusCode: {
                        this.code = Integer.parseInt(this.builder.toString());
                        break;
                    }
                    case ResponseStatusMessage: {
                        this.message = this.builder.toString();
                        break;
                    }
                    case ResponseProtocol: {
                        this.protocl = this.builder.toString();
                        break;
                    }
                    case HeaderName: {
                        this.headerName = this.builder.toString();
                        break;
                    }
                    case HeaderValue: {
                        this.headers.computeIfAbsent(this.headerName.toLowerCase(), key -> new ArrayList()).add(this.builder.toString());
                    }
                }
                if (nextState.store()) {
                    this.builder.delete(0, this.builder.length());
                    this.builder.append((char)array[i]);
                }
            } else if (this.state.store()) {
                this.builder.append((char)array[i]);
            }
            this.state = nextState;
            if (this.state == ResponseParserState.ResponseComplete) {
                this.hasBody = this.headers.containsKey("content-length");
                this.bodyOffset = this.offset;
                this.bodyLength = Integer.parseInt(this.headers.get("content-length").get(0));
                if (!this.hasBody) {
                    return true;
                }
            }
            ++this.offset;
        }
        return false;
    }

    public void markUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public void reset() {
        this.bodyBytes = 0;
        this.bodyLength = 0;
        this.bodyOffset = 0;
        this.hasBody = false;
        this.buffers.clear();
        this.builder.delete(0, this.builder.length());
        this.headers.clear();
        this.headerName = null;
        this.lastUsed = 0L;
        this.code = 0;
        this.offset = 0;
        this.message = null;
        this.protocl = null;
        this.state = ResponseParserState.ResponseStatusCode;
    }
}

