/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.client;

import io.fusionauth.http.client.ChannelPool;
import io.fusionauth.http.client.HTTPData;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class NIOClientThread
extends Thread
implements Closeable {
    private final ChannelPool pool = new ChannelPool();
    private final Selector selector = Selector.open();

    public NIOClientThread() throws IOException {
        System.out.println("Client started");
    }

    public Future<Integer> add(URI uri, String method) throws IOException {
        HTTPData data = new HTTPData();
        data.request = ByteBuffer.wrap("GET /api/system/version HTTP/1.1\r\n\r\n".getBytes());
        data.future = new CompletableFuture();
        data.host = uri.getHost();
        SocketChannel channel = this.pool.checkout(uri.getHost());
        if (channel == null) {
            channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(new InetSocketAddress(uri.getHost(), uri.getPort()));
            SelectionKey key = channel.register(this.selector, 8);
            key.attach(data);
        } else {
            SelectionKey key = channel.keyFor(this.selector);
            key.attach(data);
            key.interestOps(4);
        }
        this.selector.wakeup();
        return data.future;
    }

    @Override
    public void close() {
        try {
            this.selector.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    if (!this.selector.isOpen()) {
                        return;
                    }
                    numberOfKeys = this.selector.select();
                    if (numberOfKeys <= 0) continue;
                    keys = this.selector.selectedKeys();
                    iterator = keys.iterator();
                    while (true) {
                        if (iterator.hasNext()) ** break;
                        continue block3;
                        key = iterator.next();
                        if (key.isConnectable()) {
                            System.out.println("Connecting");
                            this.connect(key);
                        } else if (key.isReadable()) {
                            this.read(key);
                        } else if (key.isWritable()) {
                            this.write(key);
                        }
                        iterator.remove();
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void connect(SelectionKey key) throws IOException {
        SocketChannel channel = (SocketChannel)key.channel();
        if (channel.finishConnect()) {
            key.interestOps(4);
        }
    }

    private void read(SelectionKey key) throws IOException {
        HTTPData data;
        SocketChannel client = (SocketChannel)key.channel();
        long read = client.read((data = (HTTPData)key.attachment()).currentBuffer());
        if (read <= 0L) {
            return;
        }
        if (data.isResponseComplete()) {
            data.future.complete(data.code);
            key.attach(null);
            this.pool.checkin(data.host, (SocketChannel)key.channel());
        }
    }

    private void write(SelectionKey key) throws IOException {
        SocketChannel client = (SocketChannel)key.channel();
        HTTPData data = (HTTPData)key.attachment();
        client.write(data.request);
        if (data.request.position() == data.request.limit()) {
            key.interestOps(1);
        }
    }
}

