/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.server.RequestPreambleState;
import io.fusionauth.http.util.HTTPTools;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultipartStream {
    private final byte[] boundary;
    private final byte[] buffer;
    private final InputStream input;
    private int boundaryLength;
    private int boundaryStart;
    private int current;
    private int end;
    private int partialBoundary;

    public MultipartStream(InputStream input, byte[] boundary, int bufSize) {
        if (boundary == null) {
            throw new IllegalArgumentException("Boundary cannot be null.");
        }
        if (bufSize < boundary.length * 2) {
            throw new IllegalArgumentException("The buffer size specified for the MultipartStream is too small. Must be double the boundary length.");
        }
        this.input = input;
        this.buffer = new byte[bufSize];
        this.boundary = new byte[boundary.length + 4];
        this.boundaryStart = 2;
        this.boundaryLength = boundary.length + 2;
        System.arraycopy(HTTPValues.ControlBytes.MultipartBoundaryPrefix, 0, this.boundary, 0, 4);
        System.arraycopy(boundary, 0, this.boundary, 4, boundary.length);
        this.current = 0;
        this.end = 0;
    }

    public void process(Map<String, List<String>> parameters, List<FileInfo> files) throws IOException, ParseException {
        if (!this.reload(this.boundaryLength + 2)) {
            throw new ParseException("Invalid multipart body. The body is empty.");
        }
        this.current = this.findBoundary();
        if (this.current == -1) {
            throw new ParseException("Invalid multipart body. The body doesn't contain any boundaries.");
        }
        boolean hasMore = this.closeBoundary();
        this.boundaryStart = 0;
        this.boundaryLength = this.boundary.length;
        HashMap<String, HTTPTools.HeaderValue> headers = new HashMap<String, HTTPTools.HeaderValue>();
        while (hasMore) {
            this.readHeaders(headers);
            this.readPart(headers, parameters, files);
            hasMore = this.closeBoundary();
            if (!hasMore) continue;
            headers.clear();
        }
    }

    private boolean closeBoundary() throws IOException {
        boolean hasMore;
        this.current += this.boundaryLength;
        byte one = this.readByte();
        byte two = this.readByte();
        if (one == 45 && two == 45) {
            hasMore = false;
        } else if (one == 13 && two == 10) {
            hasMore = true;
        } else {
            throw new ParseException("Unexpected characters [" + new String(new byte[]{one, two}) + "] follow a boundary.");
        }
        return hasMore;
    }

    private int findBoundary() {
        int boundaryIndex = this.boundaryStart;
        for (int bufferIndex = this.current; bufferIndex < this.end; ++bufferIndex) {
            int checkIndex;
            while (bufferIndex < this.end && this.buffer[bufferIndex] != this.boundary[boundaryIndex]) {
                ++bufferIndex;
            }
            this.partialBoundary = bufferIndex < this.end ? bufferIndex : -1;
            for (checkIndex = bufferIndex; checkIndex < this.end && boundaryIndex < this.boundaryLength && this.buffer[checkIndex] == this.boundary[boundaryIndex]; ++checkIndex, ++boundaryIndex) {
            }
            if (boundaryIndex == this.boundaryLength) {
                this.partialBoundary = -1;
                return bufferIndex;
            }
            if (checkIndex == this.end) {
                return -1;
            }
            boundaryIndex = 0;
            this.partialBoundary = -1;
        }
        return -1;
    }

    private byte readByte() throws IOException {
        if (this.current == this.end && !this.reload(1)) {
            throw new ParseException("Invalid multipart body. Ran out of data while processing.");
        }
        return this.buffer[this.current++];
    }

    private void readHeaders(Map<String, HTTPTools.HeaderValue> headers) throws IOException, ParseException {
        RequestPreambleState state = RequestPreambleState.HeaderName;
        StringBuilder build = new StringBuilder();
        String headerName = null;
        while (state != RequestPreambleState.Complete) {
            byte b = this.readByte();
            RequestPreambleState nextState = state.next(b);
            if (nextState != state) {
                switch (state) {
                    case HeaderName: {
                        headerName = build.toString().toLowerCase();
                        break;
                    }
                    case HeaderValue: {
                        headers.put(headerName, HTTPTools.parseHeaderValue(build.toString()));
                    }
                }
                if (nextState.store()) {
                    build.delete(0, build.length());
                    build.appendCodePoint(b);
                }
            } else if (state.store()) {
                build.appendCodePoint(b);
            }
            state = nextState;
        }
    }

    private void readPart(Map<String, HTTPTools.HeaderValue> headers, Map<String, List<String>> parameters, List<FileInfo> files) throws IOException, ParseException {
        HTTPTools.HeaderValue disposition = headers.get("content-disposition");
        if (disposition == null) {
            throw new ParseException("Invalid multipart body. A part is missing a [Content-Disposition] header.");
        }
        String name = disposition.parameters().get("name");
        if (name == null) {
            throw new ParseException("Invalid multipart body. A part is missing a name parameter in the [Content-Disposition] header.");
        }
        String filename = disposition.parameters().get("filename");
        boolean isFile = filename != null;
        HTTPTools.HeaderValue contentType = headers.get("content-type");
        String contentTypeString = contentType != null ? contentType.value() : "application/octet-stream";
        String encodingString = contentType != null ? contentType.parameters().get("charset") : null;
        Charset encoding = encodingString != null ? Charset.forName(encodingString) : StandardCharsets.UTF_8;
        PartProcessor processor = isFile ? new FilePartProcessor(contentTypeString, encoding, filename, name) : new ParameterPartProcessor(encoding);
        try (ParameterPartProcessor parameterPartProcessor = processor;){
            int boundaryIndex;
            do {
                if ((boundaryIndex = this.findBoundary()) == -1) {
                    if (this.partialBoundary == -1) {
                        processor.process(this.current, this.end);
                    } else {
                        processor.process(this.current, this.partialBoundary);
                    }
                    if (this.reload(this.boundary.length + 2)) continue;
                    throw new ParseException("Invalid multipart body. Ran out of data while processing.");
                }
                processor.process(this.current, boundaryIndex);
                this.current = boundaryIndex;
            } while (boundaryIndex == -1);
            if (isFile) {
                files.add(processor.toFileInfo());
            } else {
                parameters.computeIfAbsent(name, key -> new LinkedList()).add(processor.toValue());
            }
        }
    }

    private boolean reload(int minimumToLoad) throws IOException {
        int start = 0;
        if (this.partialBoundary > 0) {
            System.arraycopy(this.buffer, this.partialBoundary, this.buffer, 0, this.end - this.partialBoundary);
            start = this.end - this.partialBoundary;
            this.end -= this.partialBoundary;
            this.partialBoundary = -1;
            minimumToLoad = this.boundaryLength + 2;
        } else {
            this.end = 0;
        }
        this.current = 0;
        while (this.end - this.current < minimumToLoad) {
            this.end += this.input.read(this.buffer, start, this.buffer.length - start);
            if (this.end == -1) {
                return false;
            }
            start += this.end;
        }
        return true;
    }

    private class FilePartProcessor
    implements PartProcessor {
        private final String contentType;
        private final Charset encoding;
        private final String filename;
        private final String name;
        private final OutputStream output;
        private final Path path;

        private FilePartProcessor(String contentType, Charset encoding, String filename, String name) throws IOException {
            this.contentType = contentType;
            this.encoding = encoding;
            this.filename = filename;
            this.name = name;
            this.path = Files.createTempFile("java-http", "file-upload", new FileAttribute[0]);
            this.output = Files.newOutputStream(this.path, new OpenOption[0]);
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }

        @Override
        public void process(int start, int end) throws IOException {
            this.output.write(MultipartStream.this.buffer, start, end - start);
        }

        @Override
        public FileInfo toFileInfo() throws IOException {
            this.output.close();
            return new FileInfo(this.path, this.filename, this.name, this.contentType, this.encoding);
        }

        @Override
        public String toValue() {
            throw new UnsupportedOperationException();
        }
    }

    private class ParameterPartProcessor
    implements PartProcessor {
        private final Charset encoding;
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();

        private ParameterPartProcessor(Charset encoding) {
            this.encoding = encoding;
        }

        @Override
        public void close() {
        }

        @Override
        public void process(int start, int end) {
            if (start < end) {
                this.output.write(MultipartStream.this.buffer, start, end - start);
            }
        }

        @Override
        public FileInfo toFileInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toValue() {
            return this.output.toString(this.encoding);
        }
    }

    private static interface PartProcessor
    extends Closeable {
        public void process(int var1, int var2) throws IOException;

        public FileInfo toFileInfo() throws IOException;

        public String toValue();
    }
}

