/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.io.BlockingByteBufferOutputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPProcessor;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPRequestProcessor;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPResponseProcessor;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.HTTPWorker;
import io.fusionauth.http.server.Notifier;
import io.fusionauth.http.server.ProcessorState;
import io.fusionauth.http.server.RequestState;
import io.fusionauth.http.server.ResponseState;
import io.fusionauth.http.util.ThreadPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;

public class HTTP11Processor
implements HTTPProcessor {
    private final HTTPServerConfiguration configuration;
    private final Logger logger;
    private final Notifier notifier;
    private final ByteBuffer preambleBuffer;
    private final HTTPRequest request;
    private final HTTPRequestProcessor requestProcessor;
    private final HTTPResponse response;
    private final HTTPResponseProcessor responseProcessor;
    private final ThreadPool threadPool;
    private long bytesRead;
    private long bytesWritten;
    private long firstByteReadInstant = -1L;
    private long firstByteWroteInstant = -1L;
    private Future<?> future;
    private long lastByteReadInstant = -1L;
    private long lastUsed = System.currentTimeMillis();
    private volatile ProcessorState state;

    public HTTP11Processor(HTTPServerConfiguration configuration, HTTPListenerConfiguration listener, Notifier notifier, ByteBuffer preambleBuffer, ThreadPool threadPool, String ipAddress) {
        this.configuration = configuration;
        this.logger = configuration.getLoggerFactory().getLogger(HTTP11Processor.class);
        this.notifier = notifier;
        this.preambleBuffer = preambleBuffer;
        this.threadPool = threadPool;
        this.state = ProcessorState.Read;
        this.request = new HTTPRequest(configuration.getContextPath(), configuration.getMultipartBufferSize(), listener.isTLS() ? "https" : "http", listener.getPort(), ipAddress);
        this.requestProcessor = new HTTPRequestProcessor(configuration, this.request);
        BlockingByteBufferOutputStream outputStream = new BlockingByteBufferOutputStream(notifier, configuration.getResponseBufferSize(), configuration.getMaxOutputBufferQueueLength());
        this.response = new HTTPResponse(outputStream, this.request, configuration.isCompressByDefault());
        this.responseProcessor = new HTTPResponseProcessor(configuration, this.request, this.response, outputStream);
    }

    @Override
    public ProcessorState close(boolean endOfStream) {
        this.logger.trace("(C)");
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.state = ProcessorState.Close;
        return this.state;
    }

    @Override
    public void failure(Throwable t) {
        this.logger.trace("(F)");
        if (this.response.isCommitted()) {
            this.state = ProcessorState.Close;
        } else {
            this.state = ProcessorState.Write;
            this.responseProcessor.failure();
        }
        this.notifier.notifyNow();
    }

    @Override
    public int initialKeyOps() {
        this.logger.trace("(A)");
        return 1;
    }

    @Override
    public long lastUsed() {
        return this.lastUsed;
    }

    public void markUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    @Override
    public ProcessorState read(ByteBuffer buffer) throws IOException {
        this.markUsed();
        this.bytesRead += (long)buffer.remaining();
        if (this.bytesRead > 0L) {
            this.lastByteReadInstant = this.firstByteReadInstant == -1L ? (this.firstByteReadInstant = System.currentTimeMillis()) : System.currentTimeMillis();
        }
        this.logger.trace("(R)");
        RequestState requestState = this.requestProcessor.state();
        if (requestState == RequestState.Preamble) {
            this.logger.trace("(RP)");
            requestState = this.requestProcessor.processPreambleBytes(buffer);
            if (requestState != RequestState.Preamble && requestState != RequestState.Expect) {
                this.logger.trace("(RWo)");
                this.future = this.threadPool.submit(new HTTPWorker(this.configuration.getHandler(), this.configuration.getLoggerFactory(), this, this.request, this.response));
            }
        } else {
            this.logger.trace("(RB)");
            requestState = this.requestProcessor.processBodyBytes();
        }
        if (requestState == RequestState.Expect) {
            this.logger.trace("(RE)");
            ExpectValidator expectValidator = this.configuration.getExpectValidator();
            if (expectValidator != null) {
                expectValidator.validate(this.request, this.response);
            } else {
                this.response.setStatus(100);
            }
            this.responseProcessor.resetState(ResponseState.Expect);
            this.state = ProcessorState.Write;
        } else if (requestState == RequestState.Complete) {
            this.logger.trace("(RC)");
            this.state = ProcessorState.Write;
        }
        this.logger.trace("(RR)");
        return this.state;
    }

    @Override
    public ByteBuffer readBuffer() {
        this.markUsed();
        RequestState state = this.requestProcessor.state();
        ByteBuffer buffer = state == RequestState.Preamble ? this.preambleBuffer : (state == RequestState.Body ? this.requestProcessor.bodyBuffer() : null);
        return buffer;
    }

    @Override
    public long readThroughput() {
        if (this.firstByteReadInstant == -1L || this.bytesRead == 0L || this.lastByteReadInstant == this.firstByteReadInstant) {
            return Long.MAX_VALUE;
        }
        if (this.firstByteWroteInstant == -1L) {
            long millis = System.currentTimeMillis() - this.firstByteReadInstant;
            if (millis < this.configuration.getReadThroughputCalculationDelay().toMillis()) {
                return Long.MAX_VALUE;
            }
            double result = (double)this.bytesRead / (double)millis * 1000.0;
            return Math.round(result);
        }
        double result = (double)this.bytesRead / (double)(this.lastByteReadInstant - this.firstByteReadInstant) * 1000.0;
        return Math.round(result);
    }

    @Override
    public ProcessorState state() {
        return this.state;
    }

    @Override
    public ByteBuffer[] writeBuffers() {
        ResponseState responseState = this.responseProcessor.state();
        if (responseState == ResponseState.Expect || responseState == ResponseState.Preamble || responseState == ResponseState.Body) {
            return this.responseProcessor.currentBuffer();
        }
        return null;
    }

    @Override
    public long writeThroughput() {
        if (this.firstByteWroteInstant == -1L || this.bytesWritten == 0L) {
            return Long.MAX_VALUE;
        }
        long millis = System.currentTimeMillis() - this.firstByteWroteInstant;
        if (millis < this.configuration.getWriteThroughputCalculationDelay().toMillis()) {
            return Long.MAX_VALUE;
        }
        double result = (double)this.bytesWritten / (double)millis * 1000.0;
        return Math.round(result);
    }

    @Override
    public ProcessorState wrote(long num) {
        ResponseState responseState;
        this.markUsed();
        this.bytesWritten += num;
        if (this.bytesWritten > 0L && this.firstByteWroteInstant == -1L) {
            this.firstByteWroteInstant = System.currentTimeMillis();
        }
        if (num > 0L) {
            this.logger.trace("(W)");
            this.response.setCommitted(true);
        }
        if ((responseState = this.responseProcessor.state()) == ResponseState.Continue) {
            this.logger.trace("(WCo)");
            this.requestProcessor.resetState(RequestState.Body);
            this.responseProcessor.resetState(ResponseState.Preamble);
            this.future = this.threadPool.submit(new HTTPWorker(this.configuration.getHandler(), this.configuration.getLoggerFactory(), this, this.request, this.response));
            this.state = ProcessorState.Read;
        } else if (responseState == ResponseState.KeepAlive) {
            this.logger.trace("(WKA)");
            this.state = ProcessorState.Reset;
        } else if (responseState == ResponseState.Close) {
            this.logger.trace("(WC)");
            this.state = ProcessorState.Close;
        }
        return this.state;
    }
}

