/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.log.Logger;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPProcessor;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;

public class HTTPWorker
implements Runnable {
    private final HTTPHandler handler;
    private final Logger logger;
    private final HTTPProcessor processor;
    private final HTTPRequest request;
    private final HTTPResponse response;

    public HTTPWorker(HTTPHandler handler, LoggerFactory loggerFactory, HTTPProcessor processor, HTTPRequest request, HTTPResponse response) {
        this.handler = handler;
        this.logger = loggerFactory.getLogger(HTTPWorker.class);
        this.processor = processor;
        this.request = request;
        this.response = response;
    }

    @Override
    public void run() {
        try {
            this.handler.handle(this.request, this.response);
            this.response.close();
        }
        catch (Throwable t) {
            this.logger.error("HTTP worker threw an exception while processing a request", t);
            this.processor.failure(t);
        }
    }
}

