/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.frontline.mojo;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.SelectorUtils;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.commons.FileUtilsV2_2;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class FrontLineMojo
extends AbstractMojo {
    private static final String[] ALWAYS_EXCLUDES = new String[]{"META-INF/LICENSE", "META-INF/MANIFEST.MF", "META-INF/versions/*", "*.SF", "*.DSA", "*.RSA"};
    private static String GATLING_GROUP_ID = "io.gatling";
    private static String GATLING_HIGHCHARTS_GROUP_ID = "io.gatling.highcharts";
    private static String GATLING_FRONTLINE_GROUP_ID = "io.gatling.frontline";
    private static Set<String> GATLING_GROUP_IDS;
    @Component
    private RepositorySystem repository;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter
    private String[] excludes;
    @Parameter(defaultValue="shaded")
    private String shadedClassifier;

    private Set<Artifact> nonGatlingDependencies(Artifact artifact) {
        if (artifact == null) {
            return Collections.emptySet();
        }
        return this.resolveTransitively(artifact).stream().filter(art -> !GATLING_GROUP_IDS.contains(art.getGroupId())).collect(Collectors.toSet());
    }

    public void execute() throws MojoExecutionException {
        File workingDir;
        Set allDeps = this.project.getArtifacts();
        Artifact gatlingApp = FrontLineMojo.findByGroupIdAndArtifactId(allDeps, GATLING_GROUP_ID, "gatling-app");
        Artifact gatlingChartsHighcharts = FrontLineMojo.findByGroupIdAndArtifactId(allDeps, GATLING_HIGHCHARTS_GROUP_ID, "gatling-charts-highcharts");
        Artifact frontlineProbe = FrontLineMojo.findByGroupIdAndArtifactId(allDeps, GATLING_FRONTLINE_GROUP_ID, "frontline-probe");
        if (gatlingApp == null) {
            throw new MojoExecutionException("Couldn't find io.gatling:gatling-app in project dependencies");
        }
        HashSet<Artifact> gatlingDependencies = new HashSet<Artifact>();
        gatlingDependencies.addAll(this.nonGatlingDependencies(gatlingApp));
        gatlingDependencies.addAll(this.nonGatlingDependencies(gatlingChartsHighcharts));
        gatlingDependencies.addAll(this.nonGatlingDependencies(frontlineProbe));
        Set filteredDeps = allDeps.stream().filter(artifact -> !GATLING_GROUP_IDS.contains(artifact.getGroupId()) && (!artifact.getGroupId().equals("io.netty") || !artifact.getArtifactId().equals("netty-all")) && FrontLineMojo.artifactNotIn(artifact, gatlingDependencies)).collect(Collectors.toSet());
        try {
            workingDir = Files.createTempDirectory("frontline", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create temp dir", (Exception)e);
        }
        for (Artifact artifact2 : filteredDeps) {
            ZipUtil.unpack((File)artifact2.getFile(), (File)workingDir, name -> this.exclude(name) ? null : name);
        }
        File outputDirectory = new File(this.project.getBuild().getOutputDirectory());
        Path outputDirectoryPath = outputDirectory.toPath();
        File testOutputDirectory = new File(this.project.getBuild().getTestOutputDirectory());
        Path testOutputDirectoryPath = testOutputDirectory.toPath();
        try {
            if (outputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)outputDirectory, (File)workingDir, pathname -> !this.exclude(outputDirectoryPath.relativize(pathname.toPath()).toString()), (boolean)false);
            }
            if (testOutputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)testOutputDirectory, (File)workingDir, pathname -> !this.exclude(testOutputDirectoryPath.relativize(pathname.toPath()).toString()), (boolean)false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy compiled classes", (Exception)e);
        }
        File metaInfDir = new File(workingDir, "META-INF");
        metaInfDir.mkdirs();
        File manifest = new File(metaInfDir, "MANIFEST.MF");
        try (FileWriter fw = new FileWriter(manifest);){
            fw.write("Manifest-Version: 1.0\n");
            fw.write("Implementation-Title: " + this.project.getArtifactId() + "\n");
            fw.write("Implementation-Version: " + this.project.getVersion() + "\n");
            fw.write("Implementation-Vendor: " + this.project.getGroupId() + "\n");
            fw.write("Specification-Vendor: GatlingCorp\n");
            fw.write("Gatling-Version: " + gatlingApp.getVersion() + "\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate manifest", (Exception)e);
        }
        File originalArtifact = this.project.getArtifact().getFile();
        if (originalArtifact == null || !originalArtifact.isFile()) {
            throw new MojoExecutionException("Original main artifact is invalid: " + originalArtifact);
        }
        File shaded = new File(originalArtifact.getParent(), originalArtifact.getName().replace(".jar", "-shaded.jar"));
        this.getLog().info((CharSequence)("Generating FrontLine shaded jar " + shaded));
        ZipUtil.pack((File)workingDir, (File)shaded);
        this.projectHelper.attachArtifact(this.project, "jar", this.shadedClassifier, shaded);
        try {
            FileUtilsV2_2.deleteDirectory((File)workingDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete working directory " + workingDir, (Exception)e);
        }
    }

    private boolean exclude(String name) {
        for (String pattern : ALWAYS_EXCLUDES) {
            if (!SelectorUtils.match((String)pattern, (String)name, (boolean)false)) continue;
            this.getLog().info((CharSequence)("Excluding file " + name));
            return true;
        }
        if (this.excludes != null) {
            for (String pattern : this.excludes) {
                if (!SelectorUtils.match((String)pattern, (String)name, (boolean)false)) continue;
                this.getLog().info((CharSequence)("Excluding file " + name));
                return true;
            }
        }
        return false;
    }

    private Set<Artifact> resolveTransitively(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(true).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        return this.repository.resolve(request).getArtifacts();
    }

    private static boolean artifactNotIn(Artifact target, Set<Artifact> artifacts) {
        return FrontLineMojo.findByGroupIdAndArtifactId(artifacts, target.getGroupId(), target.getArtifactId()) == null;
    }

    private static Artifact findByGroupIdAndArtifactId(Set<Artifact> artifacts, String groupId, String artifactId) {
        for (Artifact artifact : artifacts) {
            if (!artifact.getGroupId().equals(groupId) || !artifact.getArtifactId().equals(artifactId)) continue;
            return artifact;
        }
        return null;
    }

    static {
        HashSet<String> groupIds = new HashSet<String>();
        groupIds.add(GATLING_GROUP_ID);
        groupIds.add(GATLING_HIGHCHARTS_GROUP_ID);
        groupIds.add(GATLING_FRONTLINE_GROUP_ID);
        GATLING_GROUP_IDS = Collections.unmodifiableSet(groupIds);
    }
}

