/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import com.typesafe.scalalogging.slf4j.Logger;
import com.typesafe.scalalogging.slf4j.StrictLogging;
import com.typesafe.zinc.Compiler;
import com.typesafe.zinc.Compiler$;
import com.typesafe.zinc.IncOptions;
import com.typesafe.zinc.IncOptions$;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.Inputs$;
import com.typesafe.zinc.Setup;
import com.typesafe.zinc.Setup$;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import sbt.inc.Analysis;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.io.Directory;
import scala.runtime.Nothing$;
import scala.tools.nsc.io.package$;
import scala.util.Try$;
import scala.util.matching.Regex;
import xsbti.F0;
import xsbti.api.Compilation;
import xsbti.compile.CompileOrder;

public final class ZincCompiler$
implements StrictLogging {
    public static final ZincCompiler$ MODULE$;
    private final List<String> FoldersToCache;
    private final Logger logger;

    static {
        new ZincCompiler$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$slf4j$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<String> FoldersToCache() {
        return this.FoldersToCache;
    }

    public void main(String[] args) {
        String gatlingHome = args[0];
        Directory sourceDirectory = package$.MODULE$.Directory().apply(package$.MODULE$.Path().string2path(args[1]));
        String binDirectory = args[2];
        String classesDirectory = args[3];
        String encoding = args[4];
        Seq compilerOptions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-encoding", encoding, "-target:jvm-1.7", "-deprecation", "-feature", "-unchecked", "-language:implicitConversions", "-language:postfixOps"}));
        URL[] classpathURLs = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
        Setup setup = this.setupZincCompiler$1(classpathURLs);
        xsbti.Logger zincLogger = new xsbti.Logger(){

            public void error(F0<String> arg) {
                if (ZincCompiler$.MODULE$.logger().underlying().isErrorEnabled()) {
                    ZincCompiler$.MODULE$.logger().underlying().error((String)arg.apply());
                }
            }

            public void warn(F0<String> arg) {
                if (ZincCompiler$.MODULE$.logger().underlying().isWarnEnabled()) {
                    ZincCompiler$.MODULE$.logger().underlying().warn((String)arg.apply());
                }
            }

            public void info(F0<String> arg) {
                if (ZincCompiler$.MODULE$.logger().underlying().isInfoEnabled()) {
                    ZincCompiler$.MODULE$.logger().underlying().info((String)arg.apply());
                }
            }

            public void debug(F0<String> arg) {
                if (ZincCompiler$.MODULE$.logger().underlying().isDebugEnabled()) {
                    ZincCompiler$.MODULE$.logger().underlying().debug((String)arg.apply());
                }
            }

            public void trace(F0<Throwable> arg) {
                if (ZincCompiler$.MODULE$.logger().underlying().isTraceEnabled()) {
                    ZincCompiler$.MODULE$.logger().underlying().trace("", (Throwable)arg.apply());
                }
            }
        };
        Compiler zincCompiler = Compiler$.MODULE$.create(setup, zincLogger);
        Inputs inputs = this.simulationInputs$1(gatlingHome, sourceDirectory, binDirectory, classesDirectory, compilerOptions, classpathURLs);
        Inputs$.MODULE$.debug(inputs, zincLogger);
        if (Try$.MODULE$.apply((Function0)new Serializable(zincLogger, zincCompiler, inputs){
            public static final long serialVersionUID = 0L;
            private final xsbti.Logger zincLogger$1;
            private final Compiler zincCompiler$1;
            private final Inputs inputs$1;

            public final Analysis apply() {
                return this.zincCompiler$1.compile(this.inputs$1, this.zincLogger$1);
            }
            {
                this.zincLogger$1 = zincLogger$1;
                this.zincCompiler$1 = zincCompiler$1;
                this.inputs$1 = inputs$1;
            }
        }).isFailure()) {
            System.exit(1);
        }
    }

    public final Tuple2 io$gatling$app$ZincCompiler$$analysisCacheMapEntry$1(String directoryName, String gatlingHome$1, String binDirectory$1) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)package$.MODULE$.Path().string2path(gatlingHome$1).$div(package$.MODULE$.Path().string2path(directoryName)).jfile()), (Object)package$.MODULE$.Path().string2path(binDirectory$1).$div(package$.MODULE$.Path().string2path("cache")).$div(package$.MODULE$.Path().string2path(directoryName)).jfile());
    }

    private final Inputs simulationInputs$1(String gatlingHome$1, Directory sourceDirectory$1, String binDirectory$1, String classesDirectory$1, Seq compilerOptions$1, URL[] classpathURLs$1) {
        File[] classpath = (File[])Predef$.MODULE$.refArrayOps((Object[])classpathURLs$1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(URL url) {
                return new File(url.toURI());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        Seq sources = sourceDirectory$1.deepFiles().collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends scala.reflect.io.File, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.hasExtension("scala", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])) ? A1.jfile() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(scala.reflect.io.File x1) {
                scala.reflect.io.File file = x1;
                boolean bl = file.hasExtension("scala", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                return bl;
            }
        }).toSeq();
        boolean x$1 = true;
        int x$2 = IncOptions$.MODULE$.apply$default$1();
        double x$3 = IncOptions$.MODULE$.apply$default$2();
        boolean x$4 = IncOptions$.MODULE$.apply$default$3();
        boolean x$5 = IncOptions$.MODULE$.apply$default$4();
        int x$6 = IncOptions$.MODULE$.apply$default$5();
        Option x$7 = IncOptions$.MODULE$.apply$default$6();
        boolean x$8 = IncOptions$.MODULE$.apply$default$7();
        Option x$9 = IncOptions$.MODULE$.apply$default$8();
        boolean x$10 = IncOptions$.MODULE$.apply$default$9();
        return Inputs$.MODULE$.inputs((Seq)Predef$.MODULE$.wrapRefArray((Object[])classpath), sources, package$.MODULE$.Path().string2path(classesDirectory$1).jfile(), compilerOptions$1, (Seq)Nil$.MODULE$, (Option)new Some((Object)package$.MODULE$.Path().string2path(binDirectory$1).$div(package$.MODULE$.Path().string2path("zincCache")).jfile()), ((TraversableOnce)this.FoldersToCache().map((Function1)new Serializable(gatlingHome$1, binDirectory$1){
            public static final long serialVersionUID = 0L;
            private final String gatlingHome$1;
            private final String binDirectory$1;

            public final Tuple2<File, File> apply(String directoryName) {
                return ZincCompiler$.MODULE$.io$gatling$app$ZincCompiler$$analysisCacheMapEntry$1(directoryName, this.gatlingHome$1, this.binDirectory$1);
            }
            {
                this.gatlingHome$1 = gatlingHome$1;
                this.binDirectory$1 = binDirectory$1;
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()), false, false, CompileOrder.JavaThenScala, new IncOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    }

    private final File jarMatching$1(String regex, URL[] classpathURLs$1) {
        Regex compiledRegex = new StringOps(Predef$.MODULE$.augmentString(regex)).r();
        URL jarUrl = (URL)Predef$.MODULE$.refArrayOps((Object[])classpathURLs$1).find((Function1)new Serializable(compiledRegex){
            public static final long serialVersionUID = 0L;
            private final Regex compiledRegex$1;

            public final boolean apply(URL url) {
                return this.compiledRegex$1.findFirstMatchIn((CharSequence)url.toString()).isDefined();
            }
            {
                this.compiledRegex$1 = compiledRegex$1;
            }
        }).getOrElse((Function0)new Serializable(regex){
            public static final long serialVersionUID = 0L;
            private final String regex$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't find the jar matching ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.regex$1})));
            }
            {
                this.regex$1 = regex$1;
            }
        });
        return new File(jarUrl.toURI());
    }

    private final Setup setupZincCompiler$1(URL[] classpathURLs$1) {
        File scalaCompiler = this.jarMatching$1("(.*scala-compiler.*\\.jar)$", classpathURLs$1);
        File scalaLibrary = this.jarMatching$1("(.*scala-library.*\\.jar)$", classpathURLs$1);
        File scalaReflect = this.jarMatching$1("(.*scala-reflect.*\\.jar)$", classpathURLs$1);
        File sbtInterfaceSrc = new File(Compilation.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        File compilerInterfaceSrc = this.jarMatching$1("(.*compiler-interface-.*-sources.jar)$", classpathURLs$1);
        return Setup$.MODULE$.setup(scalaCompiler, scalaLibrary, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{scalaReflect})), sbtInterfaceSrc, compilerInterfaceSrc, (Option)None$.MODULE$, false);
    }

    private ZincCompiler$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.FoldersToCache = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bin", "conf", "user-files"}));
    }
}

