/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.Gatling$;
import io.gatling.app.GatlingStatusCodes$;
import io.gatling.app.classloader.SimulationClassLoader$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator$;
import io.gatling.core.assertion.AssertionResult;
import io.gatling.core.assertion.AssertionValidator$;
import io.gatling.core.config.GatlingConfiguration$;
import io.gatling.core.config.GatlingFiles$;
import io.gatling.core.result.reader.DataReader;
import io.gatling.core.result.reader.DataReader$;
import io.gatling.core.runner.Runner;
import io.gatling.core.runner.Selection;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.util.StringHelper;
import io.gatling.core.util.StringHelper$;
import io.gatling.http.util.GA$;
import java.nio.file.Path;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.io.StdIn$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003I\u0011aB$bi2Lgn\u001a\u0006\u0003\u0007\u0011\t1!\u00199q\u0015\t)a!A\u0004hCRd\u0017N\\4\u000b\u0003\u001d\t!![8\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\t9q)\u0019;mS:<7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\u00061-!\t!G\u0001\u0005[\u0006Lg\u000e\u0006\u0002\u001b;A\u0011qbG\u0005\u00039A\u0011A!\u00168ji\")ad\u0006a\u0001?\u0005!\u0011M]4t!\ry\u0001EI\u0005\u0003CA\u0011Q!\u0011:sCf\u0004\"a\t\u0014\u000f\u0005=!\u0013BA\u0013\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0005\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015\u0002\u0002\"\u0002\u0016\f\t\u0003Y\u0013a\u00024s_6l\u0015\r\u001d\u000b\u0003YM\u0002\"!\f\u0019\u000f\u0005)q\u0013BA\u0018\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\r\u001a\u0003\u0015M#\u0018\r^;t\u0007>$WM\u0003\u00020\u0005!)A'\u000ba\u0001k\u0005IqN^3se&$Wm\u001d\t\u0003[YJ!a\u000e\u001a\u0003\u001f\r{gNZ5h\u001fZ,'O]5eKNDQ!O\u0006\u0005\u0002i\n!B];o\u000f\u0006$H.\u001b8h)\ra3\b\u0010\u0005\u0006=a\u0002\ra\b\u0005\u0006{a\u0002\rAP\u0001\u0010g&lW\u000f\\1uS>t7\t\\1tgB\u0011QfP\u0005\u0003\u0001J\u0012\u0001dU3mK\u000e$X\rZ*j]\u001edWmU5nk2\fG/[8oQ\u0011A$)R$\u0011\u0005=\u0019\u0015B\u0001#\u0011\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0002\r\u0006AVk]3!MJ|W.\u0011:hg\"jW\u000f^1cY\u0016tS*\u00199\\'R\u0014\u0018N\\4-A}kF\u0006I(qi&|gnW\"mCN\u001c8lU5nk2\fG/[8o;vKc\u0006I,jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004#G\f\u001a/C\u0005A\u0015a\u0001\u001a/c!)!j\u0003C\u0001\u0017\u0006AaM]8n\u0003J<7\u000fF\u0002-\u00196CQAH%A\u0002}AQ!P%A\u0002y2Q\u0001\u0004\u0002\u0001\u0005=\u001b\"A\u0014\b\t\u0011Qr%\u0011!Q\u0001\nUB\u0001\"\u0010(\u0003\u0002\u0003\u0006IA\u0010\u0005\u0006+9#\ta\u0015\u000b\u0004)V3\u0006C\u0001\u0006O\u0011\u0015!$\u000b1\u00016\u0011\u0015i$\u000b1\u0001?\u0011\u0015Af\n\"\u0001Z\u0003\u0015\u0019H/\u0019:u+\u0005a\u0003\"B.O\t\u0013a\u0016a\u00047pC\u0012\u001c\u0016.\\;mCRLwN\\:\u0016\u0003u\u00032AX2f\u001b\u0005y&B\u00011b\u0003%IW.\\;uC\ndWM\u0003\u0002c!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011|&\u0001\u0002'jgR\u00042a\t4i\u0013\t9\u0007FA\u0003DY\u0006\u001c8\u000f\u0005\u0002j]6\t!N\u0003\u0002lY\u0006A1oY3oCJLwN\u0003\u0002n\t\u0005!1m\u001c:f\u0013\ty'N\u0001\u0006TS6,H.\u0019;j_:DQ!\u001d(\u0005\nI\f\u0001e]3mK\u000e$8+\u001b8hY\u0016\u001c\u0016.\\;mCRLwN\\%g!>\u001c8/\u001b2mKR\u0011ah\u001d\u0005\u0006iB\u0004\r!^\u0001\fg&lW\u000f\\1uS>t7\u000f\u0005\u0002.m&\u0011qO\r\u0002\u000f\u00032d7+[7vY\u0006$\u0018n\u001c8t\u0011\u0015Ih\n\"\u0003{\u0003a\u0011XO\\*j[Vd\u0017\r^5p]&3g*Z2fgN\f'/\u001f\u000b\u0004Eml\b\"\u0002?y\u0001\u0004q\u0014\u0001E:j]\u001edWmU5nk2\fG/[8o\u0011\u0015!\b\u00101\u0001v\u0011\u0019yh\n\"\u0003\u0002\u0002\u0005A\"/\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0016\u0005\u0005\r\u0001cA\b\u0002\u0006%\u0019\u0011q\u0001\t\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0002(\u0005\n\u00055\u0011aD1tWNKW.\u001e7bi&|g.\u00133\u0015\u000b\t\ny!a\u0005\t\u000f\u0005E\u0011\u0011\u0002a\u0001K\u0006)1\r\\1{u\"9\u0011QCA\u0005\u0001\u0004\u0011\u0013a\u00043fM\u0006,H\u000e\u001e\"bg\u0016t\u0015-\\3\t\u000f\u0005ea\n\"\u0003\u0002\u001c\u0005\t\u0012m]6Sk:$Um]2sSB$\u0018n\u001c8\u0015\u0003\tBq!a\bO\t\u0013\t\t#A\tj]R,'/Y2uSZ,7+\u001a7fGR$2!ZA\u0012\u0011\u0019!\u0018Q\u0004a\u0001k\"9\u0011q\u0005(\u0005\n\u0005%\u0012aD4f]\u0016\u0014\u0018\r^3SKB|'\u000f^:\u0015\u000bi\tY#a\u0010\t\u0011\u00055\u0012Q\u0005a\u0001\u0003_\tqC]3q_J$8oR3oKJ\fG/[8o\u0013:\u0004X\u000f^:\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u00051!/\u001a9peRT1!!\u000f\u0005\u0003\u0019\u0019\u0007.\u0019:ug&!\u0011QHA\u001a\u0005]\u0011V\r]8siN<UM\\3sCRLwN\\%oaV$8\u000fC\u0004Y\u0003K\u0001\r!!\u0011\u0011\u0007=\t\u0019%C\u0002\u0002FA\u0011A\u0001T8oO\"9\u0011\u0011\n(\u0005\n\u0005-\u0013!\u0003:v]N#\u0018\r^;t)\u0011\ti%a\u0015\u0011\u0007=\ty%C\u0002\u0002RA\u00111!\u00138u\u0011!\t)&a\u0012A\u0002\u0005]\u0013\u0001E1tg\u0016\u0014H/[8o%\u0016\u001cX\u000f\u001c;t!\u0019\tI&a\u001a\u0002l9!\u00111LA3\u001d\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1\u0011\u00051AH]8pizJ\u0011!E\u0005\u0003_AI1\u0001ZA5\u0015\ty\u0003\u0003\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\b\\\u0001\nCN\u001cXM\u001d;j_:LA!!\u001e\u0002p\ty\u0011i]:feRLwN\u001c*fgVdG\u000fC\u0004\u0002z9#I!a\u001f\u0002=\u0011,g-Y;mi>+H\u000f];u\t&\u0014Xm\u0019;pef\u0014\u0015m]3OC6,Gc\u0001\u0012\u0002~!9\u0011\u0011CA<\u0001\u0004)\u0007")
public class Gatling {
    private final Map<String, ?> overrides;
    private final Option<Class<Simulation>> simulationClass;

    public static int fromArgs(String[] stringArray, Option<Class<Simulation>> option) {
        return Gatling$.MODULE$.fromArgs(stringArray, option);
    }

    public static int runGatling(String[] stringArray, Option<Class<Simulation>> option) {
        return Gatling$.MODULE$.runGatling(stringArray, option);
    }

    public static int fromMap(Map<String, ?> map) {
        return Gatling$.MODULE$.fromMap(map);
    }

    public static void main(String[] stringArray) {
        Gatling$.MODULE$.main(stringArray);
    }

    public int start() {
        StringHelper$.MODULE$.checkSupportedJavaVersion();
        GatlingConfiguration$.MODULE$.setUp(this.overrides);
        List<Class<Simulation>> simulations = this.loadSimulations();
        Option<Class<Simulation>> singleSimulation = this.selectSingleSimulationIfPossible(simulations);
        String runId = this.runSimulationIfNecessary(singleSimulation, simulations);
        long start = System.currentTimeMillis();
        DataReader dataReader = DataReader$.MODULE$.newInstance(runId);
        List assertionResults = AssertionValidator$.MODULE$.validateAssertions(dataReader);
        ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runId, dataReader, assertionResults);
        if (this.reportsGenerationEnabled()) {
            this.generateReports(reportsGenerationInputs, start);
        }
        return this.runStatus((List<AssertionResult>)assertionResults);
    }

    private List<Class<Simulation>> loadSimulations() {
        boolean fromSbt = this.simulationClass.isDefined();
        boolean reportsOnly = GatlingConfiguration$.MODULE$.configuration().core().directory().reportsOnly().isDefined();
        return fromSbt || reportsOnly ? Nil$.MODULE$ : (List)SimulationClassLoader$.MODULE$.apply(GatlingFiles$.MODULE$.binariesDirectory()).simulationClasses().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Class<Simulation> x$1) {
                return x$1.getName();
            }
        }, (Ordering)Ordering.String$.MODULE$);
    }

    private Option<Class<Simulation>> selectSingleSimulationIfPossible(List<Class<Simulation>> simulations) {
        return this.simulationClass.orElse((Function0)new Serializable(this, simulations){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Gatling $outer;
            private final List simulations$1;

            public final Option<Class<Simulation>> apply() {
                return this.$outer.io$gatling$app$Gatling$$singleSimulationFromConfig$1(this.simulations$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simulations$1 = simulations$1;
            }
        }).orElse((Function0)new Serializable(this, simulations){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Gatling $outer;
            private final List simulations$1;

            public final Option<Class<Simulation>> apply() {
                return this.$outer.io$gatling$app$Gatling$$singleSimulationFromList$1(this.simulations$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simulations$1 = simulations$1;
            }
        });
    }

    private String runSimulationIfNecessary(Option<Class<Simulation>> singleSimulation, List<Class<Simulation>> simulations) {
        return (String)GatlingConfiguration$.MODULE$.configuration().core().directory().reportsOnly().getOrElse((Function0)new Serializable(this, singleSimulation, simulations){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Gatling $outer;
            private final Option singleSimulation$1;
            public final List simulations$2;

            public final String apply() {
                Class simulation = (Class)this.singleSimulation$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$runSimulationIfNecessary$1 $outer;

                    public final Class<Simulation> apply() {
                        return this.$outer.io$gatling$app$Gatling$$anonfun$$$outer().io$gatling$app$Gatling$$interactiveSelect((List<Class<Simulation>>)this.$outer.simulations$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                boolean muteModeActive = GatlingConfiguration$.MODULE$.configuration().core().muteMode() || GatlingConfiguration$.MODULE$.configuration().core().simulationClass().isDefined();
                String defaultBaseName = this.$outer.io$gatling$app$Gatling$$defaultOutputDirectoryBaseName(simulation);
                Option optionalDescription = GatlingConfiguration$.MODULE$.configuration().core().runDescription();
                String simulationId = muteModeActive ? defaultBaseName : this.$outer.io$gatling$app$Gatling$$askSimulationId(simulation, defaultBaseName);
                String runDescription = (String)optionalDescription.getOrElse((Function0)new Serializable(this, muteModeActive){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$runSimulationIfNecessary$1 $outer;
                    private final boolean muteModeActive$1;

                    public final String apply() {
                        return this.muteModeActive$1 ? "" : this.$outer.io$gatling$app$Gatling$$anonfun$$$outer().io$gatling$app$Gatling$$askRunDescription();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.muteModeActive$1 = muteModeActive$1;
                    }
                });
                Selection selection = new Selection(simulation, simulationId, runDescription);
                GA$.MODULE$.send();
                return new Runner(selection).run();
            }

            public /* synthetic */ Gatling io$gatling$app$Gatling$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.singleSimulation$1 = singleSimulation$1;
                this.simulations$2 = simulations$2;
            }
        });
    }

    private boolean reportsGenerationEnabled() {
        return GatlingConfiguration$.MODULE$.configuration().data().fileDataWriterEnabled() && !GatlingConfiguration$.MODULE$.configuration().charting().noReports();
    }

    public String io$gatling$app$Gatling$$askSimulationId(Class<Simulation> clazz, String defaultBaseName) {
        String input = this.loop$1(defaultBaseName);
        return new StringOps(Predef$.MODULE$.augmentString(input)).nonEmpty() ? input : defaultBaseName;
    }

    public String io$gatling$app$Gatling$$askRunDescription() {
        Predef$.MODULE$.println((Object)"Select run description (optional)");
        return StdIn$.MODULE$.readLine().trim();
    }

    public Class<Simulation> io$gatling$app$Gatling$$interactiveSelect(List<Class<Simulation>> simulations) {
        Range validRange = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), simulations.size());
        if (simulations.isEmpty()) {
            Predef$.MODULE$.println((Object)"There is no simulation script. Please check that your scripts are in user-files/simulations");
            throw package$.MODULE$.exit();
        }
        return (Class)simulations.apply(this.readSimulationNumber$1(simulations, validRange));
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs, long start) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        Path indexFile = ReportsGenerator$.MODULE$.generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reports generated in ", "s."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((System.currentTimeMillis() - start) / 1000L))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please open the following file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexFile.toFile()})));
    }

    private int runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean isValid, AssertionResult assertionResult) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{assertionResult.message(), BoxesRunTime.boxToBoolean((boolean)assertionResult.result())})));
                return isValid && assertionResult.result();
            }
        }));
        return consolidatedAssertionResult ? GatlingStatusCodes$.MODULE$.Success() : GatlingStatusCodes$.MODULE$.AssertionsFailed();
    }

    public String io$gatling$app$Gatling$$defaultOutputDirectoryBaseName(Class<Simulation> clazz) {
        return (String)GatlingConfiguration$.MODULE$.configuration().core().outputDirectoryBaseName().getOrElse((Function0)new Serializable(this, clazz){
            public static final long serialVersionUID = 0L;
            private final Class clazz$1;

            public final String apply() {
                return StringHelper.RichString$.MODULE$.clean$extension(StringHelper$.MODULE$.RichString(this.clazz$1.getSimpleName()));
            }
            {
                this.clazz$1 = clazz$1;
            }
        });
    }

    public final Option io$gatling$app$Gatling$$singleSimulationFromConfig$1(List simulations$1) {
        return GatlingConfiguration$.MODULE$.configuration().core().simulationClass().flatMap((Function1)new Serializable(this, simulations$1){
            public static final long serialVersionUID = 0L;
            private final List simulations$1;

            public final Option<Class<Simulation>> apply(String className) {
                Option option;
                block4: {
                    Some some;
                    block3: {
                        block2: {
                            option = this.simulations$1.find((Function1)new Serializable(this, className){
                                public static final long serialVersionUID = 0L;
                                private final String className$1;

                                public final boolean apply(Class<Simulation> x$2) {
                                    String string = x$2.getCanonicalName();
                                    String string2 = this.className$1;
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }
                                {
                                    this.className$1 = className$1;
                                }
                            });
                            if (!(option instanceof Some)) break block2;
                            Some some2 = (Some)option;
                            Class simulation = (Class)some2.x();
                            some = new Some((Object)simulation);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        Console$.MODULE$.err().println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The requested class('", "') can not be found in the classpath or does not extends Simulation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className})));
                        some = None$.MODULE$;
                    }
                    return some;
                }
                throw new MatchError((Object)option);
            }
            {
                this.simulations$1 = simulations$1;
            }
        });
    }

    public final Option io$gatling$app$Gatling$$singleSimulationFromList$1(List simulations$1) {
        None$ none$;
        if (simulations$1.size() == 1) {
            Class simulation = (Class)simulations$1.head();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is the only simulation, executing it."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{simulation.getName()})));
            none$ = new Some((Object)simulation);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final String loop$1(String defaultBaseName$1) {
        while (true) {
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Select simulation id (default is '", "'). Accepted characters are a-z, A-Z, 0-9, - and _"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{defaultBaseName$1})));
            String input = StdIn$.MODULE$.readLine().trim();
            if (input.matches("[\\w-_]*")) {
                return input;
            }
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " contains illegal characters"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input})));
        }
    }

    private final int readSimulationNumber$1(List simulations$3, Range validRange$1) {
        while (true) {
            Predef$.MODULE$.println((Object)"Choose a simulation number:");
            ((TraversableLike)simulations$3.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Class<Simulation>, Object> check$ifrefutable$1) {
                    Tuple2<Class<Simulation>, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Class<Simulation>, Object> x$3) {
                    Tuple2<Class<Simulation>, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        Class simulation = (Class)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"     [", "] ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), simulation.getName()})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return StdIn$.MODULE$.readInt();
                }
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int number = BoxesRunTime.unboxToInt((Object)success.value());
                if (validRange$1.contains(number)) {
                    int n = number;
                    return n;
                }
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid selection, must be in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{validRange$1})));
                continue;
            }
            Predef$.MODULE$.println((Object)"Invalid characters, please provide a correct simulation number:");
        }
    }

    public Gatling(Map<String, ?> overrides, Option<Class<Simulation>> simulationClass) {
        this.overrides = overrides;
        this.simulationClass = simulationClass;
    }
}

