/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Ga$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dsAB\u0001\u0003\u0011\u0003\u0011\u0001\"\u0001\u0004Sk:tWM\u001d\u0006\u0003\u0007\u0011\t1!\u00199q\u0015\t)a!A\u0004hCRd\u0017N\\4\u000b\u0003\u001d\t!![8\u0011\u0005%QQ\"\u0001\u0002\u0007\r-\u0011\u0001\u0012\u0001\u0002\r\u0005\u0019\u0011VO\u001c8feN\u0011!\"\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bQQA\u0011\u0001\f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001\u0003\u0005\u00061)!\t!G\u0001\u0006CB\u0004H.\u001f\u000b\u00065\u0005\r\u0013Q\t\t\u0003\u0013m1Qa\u0003\u0002\u0001\tq\u00192aG\u0007\u001e!\tqR%D\u0001 \u0015\t\u0001\u0013%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002#G\u0005AA/\u001f9fg\u00064WMC\u0001%\u0003\r\u0019w.\\\u0005\u0003M}\u0011Qb\u0015;sS\u000e$Hj\\4hS:<\u0007\u0002\u0003\u0015\u001c\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\rML8\u000f^3n!\tQs&D\u0001,\u0015\taS&A\u0003bGR|'OC\u0001/\u0003\u0011\t7n[1\n\u0005AZ#aC!di>\u00148+_:uK6D\u0001BM\u000e\u0003\u0002\u0003\u0006IaM\u0001\u0006G2|7m\u001b\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA!\u001e;jY*\u0011\u0001\bB\u0001\bG>lWn\u001c8t\u0013\tQTGA\u0003DY>\u001c7\u000e\u0003\u0005=7\t\u0005\t\u0015!\u0003>\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007G>tg-[4\u000b\u0005\t#\u0011\u0001B2pe\u0016L!\u0001R \u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0011\u0015!2\u0004\"\u0001G)\u0011Qr\tS%\t\u000b!*\u0005\u0019A\u0015\t\u000bI*\u0005\u0019A\u001a\t\u000bq*\u0005\u0019A\u001f\t\r-[B\u0011\u0001\u0002M\u0003\r\u0011XO\u001c\u000b\u0003\u001bB\u0003\"!\u0003(\n\u0005=\u0013!!\u0003*v]J+7/\u001e7u\u0011\u0015\t&\n1\u0001S\u0003]\u0019X\r\\3di\u0016$7+[7vY\u0006$\u0018n\u001c8DY\u0006\u001c8\u000f\u0005\u0002T-:\u0011\u0011\u0002V\u0005\u0003+\n\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n92+\u001a7fGR,GmU5nk2\fG/[8o\u00072\f7o\u001d\u0006\u0003+\nAQAW\u000e\u0005\u0012m\u000baB\\3x'R\fGo]#oO&tW\rF\u0002]E*\u0004\"!\u00181\u000e\u0003yS!aX!\u0002\u000bM$\u0018\r^:\n\u0005\u0005t&aC*uCR\u001cXI\\4j]\u0016DQaY-A\u0002\u0011\f\u0001c]5nk2\fG/[8o!\u0006\u0014\u0018-\\:\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\f\u0015\u0001C:dK:\f'/[8\n\u0005%4'\u0001E*j[Vd\u0017\r^5p]B\u000b'/Y7t\u0011\u0015Y\u0017\f1\u0001m\u0003)\u0011XO\\'fgN\fw-\u001a\t\u0003[Bl\u0011A\u001c\u0006\u0003_z\u000baa\u001e:ji\u0016\u0014\u0018BA9o\u0005)\u0011VO\\'fgN\fw-\u001a\u0005\u0006gn!I\u0001^\u0001\u0005eVt\u0007\u0007\u0006\u0002Nk\")\u0011K\u001da\u0001%\"1qo\u0007C\t\ta\fQa\u001d;beR$r!_A\u000b\u0003/\t9\u0004M\u0002{\u0003\u0007\u00012a_?\u0000\u001b\u0005a(B\u0001\u001c\u0010\u0013\tqHPA\u0002Uef\u0004B!!\u0001\u0002\u00041\u0001AaCA\u0003m\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00132#\u0011\tI!a\u0004\u0011\u00079\tY!C\u0002\u0002\u000e=\u0011qAT8uQ&tw\rE\u0002\u000f\u0003#I1!a\u0005\u0010\u0005\r\te.\u001f\u0005\u0006GZ\u0004\r\u0001\u001a\u0005\b\u000331\b\u0019AA\u000e\u0003%\u00198-\u001a8be&|7\u000f\u0005\u0004\u0002\u001e\u0005-\u0012\u0011\u0007\b\u0005\u0003?\tIC\u0004\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#F\u0001\u0007yI|w\u000e\u001e \n\u0003AI!!V\b\n\t\u00055\u0012q\u0006\u0002\u0005\u0019&\u001cHO\u0003\u0002V\u001fA\u0019Q-a\r\n\u0007\u0005UbM\u0001\u0005TG\u0016t\u0017M]5p\u0011\u001d\tID\u001ea\u0001\u0003w\tabY8sK\u000e{W\u000e]8oK:$8\u000f\u0005\u0003\u0002>\u0005}R\"A!\n\u0007\u0005\u0005\u0013I\u0001\bD_J,7i\\7q_:,g\u000e^:\t\u000b!:\u0002\u0019A\u0015\t\u000bq:\u0002\u0019A\u001f")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final Logger logger;

    public static Runner apply(ActorSystem actorSystem, GatlingConfiguration gatlingConfiguration) {
        return Runner$.MODULE$.apply(actorSystem, gatlingConfiguration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RunResult run(Option<Class<Simulation>> selectedSimulationClass) {
        RunResult runResult;
        Option option = this.configuration.core().directory().reportsOnly();
        if (option instanceof Some) {
            Some some = (Some)option;
            String runId = (String)some.value();
            runResult = new RunResult(runId, true);
        } else {
            if (this.configuration.http().enableGA()) {
                Ga$.MODULE$.send(this.configuration.core().version());
            }
            runResult = this.run0(selectedSimulationClass);
        }
        return runResult;
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.configuration);
    }

    private RunResult run0(Option<Class<Simulation>> selectedSimulationClass) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.clock_$eq(this.clock);
        Predef$.MODULE$.configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(selectedSimulationClass, this.configuration);
        Simulation simulation = selection.simulationClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation instantiated");
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        SimulationParams simulationParams = simulation.params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        simulation.executeBefore();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hooks executed");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), this.configuration.core().version());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Throttler throttler = Throttler$.MODULE$.apply(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams, this.configuration), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector, this.clock);
        CoreComponents coreComponents = new CoreComponents(this.system, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        List scenarios = simulationParams.scenarios(coreComponents);
        System.gc();
        Try<?> try_ = this.start(simulationParams, (List<Scenario>)scenarios, coreComponents);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulation.executeAfter();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hooks executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunResult runResult = new RunResult(runMessage.runId(), simulationParams.assertions().nonEmpty());
        return runResult;
    }

    public Try<?> start(SimulationParams simulationParams, List<Scenario> scenarios, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringBuilder(22).append("Simulation ").append(simulationParams.name()).append(" started...").toString());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarios);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringBuilder(33).append("Simulation ").append(simulationParams.name()).append(" completed in ").append((coreComponents.clock().nowMillis() - start) / 1000L).append(" seconds").toString());
        return runDone;
    }

    public Runner(ActorSystem system, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
    }
}

