/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.Analytics$;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.cli.GatlingArgs;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.inject.ScenarioFlows;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005-uA\u0002\t\u0012\u0011\u0003\u0019rC\u0002\u0004\u001a#!\u00051C\u0007\u0005\u0006C\u0005!\ta\t\u0005\u0006I\u0005!\t!\n\u0004\u00063E\u00011c\n\u0005\te\u0011\u0011\t\u0011)A\u0005g!A1\b\u0002B\u0001B\u0003%A\b\u0003\u0005E\t\t\u0005\t\u0015!\u0003F\u0011!iEA!A!\u0002\u0013q\u0005\u0002\u0003,\u0005\u0005\u0003\u0005\u000b\u0011B,\t\u000b\u0005\"A\u0011A/\t\r\r$AQA\te\u0011\u0015AG\u0001\"\u0005j\u0011!\t\t\u0001\u0002C\t'\u0005\r\u0001\u0002CA%\t\u0011E1#a\u0013\t\u000f\u0005eD\u0001\"\u0005\u0002|\u00051!+\u001e8oKJT!AE\n\u0002\u0007\u0005\u0004\bO\u0003\u0002\u0015+\u00059q-\u0019;mS:<'\"\u0001\f\u0002\u0005%|\u0007C\u0001\r\u0002\u001b\u0005\t\"A\u0002*v]:,'o\u0005\u0002\u00027A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002/\u0005)\u0011\r\u001d9msRIa%a!\u0002\u0006\u0006\u001d\u0015\u0011\u0012\t\u00031\u0011\u00192\u0001B\u000e)!\tI\u0003'D\u0001+\u0015\tYC&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002.]\u0005AA/\u001f9fg\u00064WMC\u00010\u0003\r\u0019w.\\\u0005\u0003c)\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017AB:zgR,W\u000e\u0005\u00025s5\tQG\u0003\u00027o\u0005)\u0011m\u0019;pe*\t\u0001(\u0001\u0003bW.\f\u0017B\u0001\u001e6\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u001d\u00154XM\u001c;M_>\u0004xI]8vaB\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\bG\"\fgN\\3m\u0015\t\tU#A\u0003oKR$\u00180\u0003\u0002D}\tqQI^3oi2{w\u000e]$s_V\u0004\u0018!B2m_\u000e\\\u0007C\u0001$L\u001b\u00059%B\u0001%J\u0003\u0011)H/\u001b7\u000b\u0005)\u001b\u0012aB2p[6|gn]\u0005\u0003\u0019\u001e\u0013Qa\u00117pG.\f1bZ1uY&tw-\u0011:hgB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0004G2L'BA*\u0014\u0003\u0011\u0019wN]3\n\u0005U\u0003&aC$bi2LgnZ!sON\fQbY8oM&<WO]1uS>t\u0007C\u0001-\\\u001b\u0005I&B\u0001.S\u0003\u0019\u0019wN\u001c4jO&\u0011A,\u0017\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\r\u0019rv\fY1c\u0011\u0015\u0011$\u00021\u00014\u0011\u0015Y$\u00021\u0001=\u0011\u0015!%\u00021\u0001F\u0011\u0015i%\u00021\u0001O\u0011\u00151&\u00021\u0001X\u0003\r\u0011XO\u001c\u000b\u0002KB\u0011\u0001DZ\u0005\u0003OF\u0011\u0011BU;o%\u0016\u001cX\u000f\u001c;\u0002\u001d9,wo\u0015;biN,enZ5oKR\u0019!\u000e\u001d=\u0011\u0005-tW\"\u00017\u000b\u00055\u0014\u0016!B:uCR\u001c\u0018BA8m\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\t\u000bEd\u0001\u0019\u0001:\u0002!MLW.\u001e7bi&|g\u000eU1sC6\u001c\bCA:w\u001b\u0005!(BA;S\u0003!\u00198-\u001a8be&|\u0017BA<u\u0005A\u0019\u0016.\\;mCRLwN\u001c)be\u0006l7\u000fC\u0003z\u0019\u0001\u0007!0\u0001\u0006sk:lUm]:bO\u0016\u0004\"a\u001f@\u000e\u0003qT!! 7\u0002\r]\u0014\u0018\u000e^3s\u0013\tyHP\u0001\u0006Sk:lUm]:bO\u0016\fA\u0001\\8bIR!\u0011QAA !%a\u0012q\u0001:{\u0003\u0017\t\u0019\"C\u0002\u0002\nu\u0011a\u0001V;qY\u0016$\u0004\u0003BA\u0007\u0003\u001fi\u0011AU\u0005\u0004\u0003#\u0011&AD\"pe\u0016\u001cu.\u001c9p]\u0016tGo\u001d\t\t\u0003+\ty\"a\t\u0002:5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004j]*,7\r\u001e\u0006\u0004\u0003;\u0011\u0016AC2p]R\u0014x\u000e\u001c7fe&!\u0011\u0011EA\f\u00055\u00196-\u001a8be&|g\t\\8xgB!\u0011QEA\u001a\u001d\u0011\t9#a\f\u0011\u0007\u0005%R$\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0012\u0002\rq\u0012xn\u001c;?\u0013\r\t\t$H\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ER\u0004E\u0002t\u0003wI1!!\u0010u\u0005!\u00196-\u001a8be&|\u0007bBA!\u001b\u0001\u0007\u00111I\u0001\ng\u0016dWm\u0019;j_:\u00042\u0001GA#\u0013\r\t9%\u0005\u0002\n'\u0016dWm\u0019;j_:\fQa\u001d;beR$\u0002\"!\u0014\u0002p\u0005E\u0014Q\u000f\u0019\u0005\u0003\u001f\ni\u0006\u0005\u0004\u0002R\u0005U\u0013\u0011L\u0007\u0003\u0003'R!\u0001S\u000f\n\t\u0005]\u00131\u000b\u0002\u0004)JL\b\u0003BA.\u0003;b\u0001\u0001B\u0006\u0002`9\t\t\u0011!A\u0003\u0002\u0005\u0005$aA0%cE!\u00111MA5!\ra\u0012QM\u0005\u0004\u0003Oj\"a\u0002(pi\"Lgn\u001a\t\u00049\u0005-\u0014bAA7;\t\u0019\u0011I\\=\t\u000bEt\u0001\u0019\u0001:\t\u000f\u0005Md\u00021\u0001\u0002\u0014\u0005i1oY3oCJLwN\u00127poNDq!a\u001e\u000f\u0001\u0004\tY!\u0001\bd_J,7i\\7q_:,g\u000e^:\u0002+\u0011L7\u000f\u001d7bsZ+'o]5p]^\u000b'O\\5oOR\u0011\u0011Q\u0010\t\u00049\u0005}\u0014bAAA;\t!QK\\5u\u0011\u0015\u00114\u00011\u00014\u0011\u0015Y4\u00011\u0001=\u0011\u0015i5\u00011\u0001O\u0011\u001516\u00011\u0001X\u0001")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final GatlingArgs gatlingArgs;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public static Runner apply(ActorSystem system, EventLoopGroup eventLoopGroup, GatlingArgs gatlingArgs, GatlingConfiguration configuration) {
        return Runner$.MODULE$.apply(system, eventLoopGroup, gatlingArgs, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public final RunResult run() {
        BoxedUnit boxedUnit;
        Tuple4<SimulationParams, RunMessage, CoreComponents, ScenarioFlows<String, Scenario>> tuple4;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.displayVersionWarning();
        Predef$.MODULE$._configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(this.gatlingArgs);
        if (this.configuration.data().enableAnalytics()) {
            Analytics$.MODULE$.send(selection.simulationClass(), (Option<String>)this.gatlingArgs.launcher(), (Option<String>)this.gatlingArgs.buildToolVersion());
        }
        if ((tuple4 = this.load(selection)) == null) {
            throw new MatchError(tuple4);
        }
        SimulationParams simulationParams = (SimulationParams)tuple4._1();
        RunMessage runMessage = (RunMessage)tuple4._2();
        CoreComponents coreComponents = (CoreComponents)tuple4._3();
        ScenarioFlows scenarioFlows = (ScenarioFlows)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)simulationParams, (Object)runMessage, (Object)coreComponents, (Object)scenarioFlows);
        SimulationParams simulationParams2 = (SimulationParams)tuple42._1();
        RunMessage runMessage2 = (RunMessage)tuple42._2();
        CoreComponents coreComponents2 = (CoreComponents)tuple42._3();
        ScenarioFlows scenarioFlows2 = (ScenarioFlows)tuple42._4();
        Try<?> try_ = this.start(simulationParams2, (ScenarioFlows<String, Scenario>)scenarioFlows2, coreComponents2);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulationParams2.after().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hook executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new RunResult(runMessage2.runId(), simulationParams2.assertions().nonEmpty());
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.gatlingArgs.resultsDirectory(), this.configuration);
    }

    public Tuple4<SimulationParams, RunMessage, CoreComponents, ScenarioFlows<String, Scenario>> load(Selection selection) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        SimulationParams simulationParams = selection.simulationClass().params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        simulationParams.before().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hook executed");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), GatlingVersion$.MODULE$.ThisVersion().fullVersion(), this.configuration.data().zoneId());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Option throttler = Throttler$.MODULE$.newThrottler(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, this.eventLoopGroup, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector);
        CoreComponents coreComponents = new CoreComponents(this.system, this.eventLoopGroup, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ScenarioFlows scenarioFlows = simulationParams.scenarioFlows(coreComponents);
        return new Tuple4((Object)simulationParams, (Object)runMessage, (Object)coreComponents, (Object)scenarioFlows);
    }

    public Try<?> start(SimulationParams simulationParams, ScenarioFlows<String, Scenario> scenarioFlows, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)("Simulation " + simulationParams.name() + " started..."));
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarioFlows);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)("Simulation " + simulationParams.name() + " completed in " + (coreComponents.clock().nowMillis() - start) / 1000L + " seconds"));
        return runDone;
    }

    public void displayVersionWarning() {
        GatlingVersion$.MODULE$.LatestRelease().foreach((Function1 & Serializable)latest -> {
            Runner.$anonfun$displayVersionWarning$1(latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$displayVersionWarning$1(GatlingVersion latest) {
        String string = latest.fullVersion();
        String string2 = GatlingVersion$.MODULE$.ThisVersion().fullVersion();
        if ((string == null ? string2 != null : !string.equals(string2)) && latest.releaseDate().isAfter(GatlingVersion$.MODULE$.ThisVersion().releaseDate())) {
            scala.Predef$.MODULE$.println((Object)("Gatling " + latest.fullVersion() + " is available! (you're using " + GatlingVersion$.MODULE$.ThisVersion().fullVersion() + ")"));
            return;
        }
    }

    public Runner(ActorSystem system, EventLoopGroup eventLoopGroup, Clock clock, GatlingArgs gatlingArgs, GatlingConfiguration configuration) {
        this.system = system;
        this.eventLoopGroup = eventLoopGroup;
        this.clock = clock;
        this.gatlingArgs = gatlingArgs;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

