/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import io.gatling.app.RunResult;
import io.gatling.app.cli.StatusCode;
import io.gatling.app.cli.StatusCode$AssertionsFailed$;
import io.gatling.app.cli.StatusCode$Success$;
import io.gatling.charts.report.ReportsGenerationInputs;
import io.gatling.charts.report.ReportsGenerator;
import io.gatling.charts.stats.LogFileReader;
import io.gatling.commons.stats.GeneralStatsSource;
import io.gatling.commons.stats.assertion.AssertionResult;
import io.gatling.commons.stats.assertion.AssertionValidator$;
import io.gatling.core.config.GatlingConfiguration;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4AAC\u0006\u0007%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0004\u001e\u0001\t\u0007I1B\u0014\t\r!\u0002\u0001\u0015!\u0003\u001b\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u00151\u0004\u0001\"\u00038\u0011\u0015!\u0005\u0001\"\u0003F\u0011\u0015I\u0005\u0001\"\u0003K\u0011\u00151\u0006\u0001\"\u0003X\u0005I\u0011VO\u001c*fgVdG\u000f\u0015:pG\u0016\u001c8o\u001c:\u000b\u00051i\u0011aA1qa*\u0011abD\u0001\bO\u0006$H.\u001b8h\u0015\u0005\u0001\u0012AA5p\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0007G>tg-[4\u000b\u0005}i\u0011\u0001B2pe\u0016L!!\t\u000f\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0011AE\n\t\u0003K\u0001i\u0011a\u0003\u0005\u00063\t\u0001\rAG\u000b\u00025\u000591m\u001c8gS\u001e\u0004\u0013\u0001\u00059s_\u000e,7o\u001d*v]J+7/\u001e7u)\tY\u0013\u0007\u0005\u0002-_5\tQF\u0003\u0002/\u0017\u0005\u00191\r\\5\n\u0005Aj#AC*uCR,8oQ8eK\")!'\u0002a\u0001g\u0005I!/\u001e8SKN,H\u000e\u001e\t\u0003KQJ!!N\u0006\u0003\u0013I+hNU3tk2$\u0018!E5oSRdun\u001a$jY\u0016\u0014V-\u00193feR\u0011\u0001h\u0011\t\u0004)eZ\u0014B\u0001\u001e\u0016\u0005\u0019y\u0005\u000f^5p]B\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0006gR\fGo\u001d\u0006\u0003\u00016\taa\u00195beR\u001c\u0018B\u0001\">\u00055aun\u001a$jY\u0016\u0014V-\u00193fe\")!G\u0002a\u0001g\u0005A\"/\u001a9peR\u001cx)\u001a8fe\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0016\u0003\u0019\u0003\"\u0001F$\n\u0005!+\"a\u0002\"p_2,\u0017M\\\u0001\u0010O\u0016tWM]1uKJ+\u0007o\u001c:ugR\u00111J\u0014\t\u0003)1K!!T\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001f\"\u0001\r\u0001U\u0001\u0018e\u0016\u0004xN\u001d;t\u000f\u0016tWM]1uS>t\u0017J\u001c9viN\u0004\"!\u0015+\u000e\u0003IS!aU \u0002\rI,\u0007o\u001c:u\u0013\t)&KA\fSKB|'\u000f^:HK:,'/\u0019;j_:Le\u000e];ug\u0006I!/\u001e8Ti\u0006$Xo\u001d\u000b\u0003WaCQ!W\u0005A\u0002i\u000b\u0001#Y:tKJ$\u0018n\u001c8SKN,H\u000e^:\u0011\u0007m\u001bgM\u0004\u0002]C:\u0011Q\fY\u0007\u0002=*\u0011q,E\u0001\u0007yI|w\u000e\u001e \n\u0003YI!AY\u000b\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002c+A\u0011q-\\\u0007\u0002Q*\u0011\u0011N[\u0001\nCN\u001cXM\u001d;j_:T!AP6\u000b\u00051l\u0011aB2p[6|gn]\u0005\u0003]\"\u0014q\"Q:tKJ$\u0018n\u001c8SKN,H\u000e\u001e")
public final class RunResultProcessor {
    private final GatlingConfiguration configuration;
    private final GatlingConfiguration config;

    private GatlingConfiguration config() {
        return this.config;
    }

    public StatusCode processRunResult(RunResult runResult) {
        StatusCode statusCode;
        GatlingConfiguration gatlingConfiguration = this.config();
        Option<LogFileReader> option = this.initLogFileReader(runResult);
        if (option instanceof Some) {
            Some some = (Some)option;
            LogFileReader reader = (LogFileReader)some.value();
            List assertionResults = AssertionValidator$.MODULE$.validateAssertions((GeneralStatsSource)reader);
            if (this.reportsGenerationEnabled()) {
                ReportsGenerationInputs reportsGenerationInputs = new ReportsGenerationInputs(runResult.runId(), reader, assertionResults);
                this.generateReports(reportsGenerationInputs);
            }
            statusCode = this.runStatus((List<AssertionResult>)assertionResults);
        } else {
            statusCode = StatusCode$Success$.MODULE$;
        }
        return (StatusCode)gatlingConfiguration.resolve((Object)statusCode);
    }

    private Option<LogFileReader> initLogFileReader(RunResult runResult) {
        return this.reportsGenerationEnabled() || runResult.hasAssertions() ? new Some((Object)new LogFileReader(runResult.runId(), this.config())) : None$.MODULE$;
    }

    private boolean reportsGenerationEnabled() {
        return this.configuration.core().directory().reportsOnly().isDefined() || this.configuration.data().fileDataWriterEnabled() && !this.configuration.charting().noReports();
    }

    private void generateReports(ReportsGenerationInputs reportsGenerationInputs) {
        Predef$.MODULE$.println((Object)"Generating reports...");
        long start = System.currentTimeMillis();
        Path indexFile = new ReportsGenerator(this.config()).generateFor(reportsGenerationInputs);
        Predef$.MODULE$.println((Object)new StringBuilder(23).append("Reports generated in ").append((System.currentTimeMillis() - start) / 1000L).append("s.").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(32).append("Please open the following file: ").append(indexFile.toFile()).toString());
    }

    private StatusCode runStatus(List<AssertionResult> assertionResults) {
        boolean consolidatedAssertionResult = BoxesRunTime.unboxToBoolean((Object)assertionResults.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(isValid, assertionResult) -> BoxesRunTime.boxToBoolean((boolean)RunResultProcessor.$anonfun$runStatus$1(BoxesRunTime.unboxToBoolean((Object)isValid), assertionResult))));
        return consolidatedAssertionResult ? StatusCode$Success$.MODULE$ : StatusCode$AssertionsFailed$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$runStatus$1(boolean isValid, AssertionResult assertionResult) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(assertionResult.message()).append(" : ").append(assertionResult.result()).toString());
        return isValid && assertionResult.result();
    }

    public RunResultProcessor(GatlingConfiguration configuration) {
        this.configuration = configuration;
        this.config = configuration;
    }
}

