/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Ga$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.throttle.Throttler;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenarios;
import io.gatling.core.scenario.Simulation;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import io.netty.channel.EventLoopGroup;
import scala.Option;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%s!\u0002\b\u0010\u0011\u00131b!\u0002\r\u0010\u0011\u0013I\u0002\"\u0002\u0011\u0002\t\u0003\t\u0003\"\u0002\u0012\u0002\t\u0003\u0019c!\u0002\r\u0010\u0001E)\u0003\u0002\u0003\u0019\u0005\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011e\"!\u0011!Q\u0001\niB\u0001B\u0011\u0003\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0017\u0012\u0011\t\u0011)A\u0005\u0019\")\u0001\u0005\u0002C\u0001)\"1\u0011\f\u0002C\u0001\u001fiCQa\u001a\u0003\u0005\u0012!Daa \u0003\u0005\n\u0005\u0005\u0001\u0002CA\u0003\t\u0011E\u0011#a\u0002\u0002\rI+hN\\3s\u0015\t\u0001\u0012#A\u0002baBT!AE\n\u0002\u000f\u001d\fG\u000f\\5oO*\tA#\u0001\u0002j_\u000e\u0001\u0001CA\f\u0002\u001b\u0005y!A\u0002*v]:,'o\u0005\u0002\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\u0011\n\u0019%!\u0012\u0002HA\u0011q\u0003B\n\u0004\ti1\u0003CA\u0014/\u001b\u0005A#BA\u0015+\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tYC&\u0001\u0005usB,7/\u00194f\u0015\u0005i\u0013aA2p[&\u0011q\u0006\u000b\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\rML8\u000f^3n!\t\u0011t'D\u00014\u0015\t!T'A\u0003bGR|'OC\u00017\u0003\u0011\t7n[1\n\u0005a\u001a$aC!di>\u00148+_:uK6\fa\"\u001a<f]Rdun\u001c9He>,\b\u000f\u0005\u0002<\u00016\tAH\u0003\u0002>}\u000591\r[1o]\u0016d'BA \u0014\u0003\u0015qW\r\u001e;z\u0013\t\tEH\u0001\bFm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0002\u000b\rdwnY6\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015\u0001B;uS2T!\u0001S\t\u0002\u000f\r|W.\\8og&\u0011!*\u0012\u0002\u0006\u00072|7m[\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u00055\u0013V\"\u0001(\u000b\u0005=\u0003\u0016AB2p]\u001aLwM\u0003\u0002R#\u0005!1m\u001c:f\u0013\t\u0019fJ\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u000b\u0006IU3v\u000b\u0017\u0005\u0006a%\u0001\r!\r\u0005\u0006s%\u0001\rA\u000f\u0005\u0006\u0005&\u0001\ra\u0011\u0005\u0006\u0017&\u0001\r\u0001T\u0001\u0004eVtGCA._!\t9B,\u0003\u0002^\u001f\tI!+\u001e8SKN,H\u000e\u001e\u0005\u0006?*\u0001\r\u0001Y\u0001\u0018g\u0016dWm\u0019;fINKW.\u001e7bi&|gn\u00117bgN\u0004\"!\u00193\u000f\u0005]\u0011\u0017BA2\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001a4\u0003/M+G.Z2uK\u0012\u001c\u0016.\\;mCRLwN\\\"mCN\u001c(BA2\u0010\u00039qWm^*uCR\u001cXI\\4j]\u0016$2![8x!\tQW.D\u0001l\u0015\ta\u0007+A\u0003ti\u0006$8/\u0003\u0002oW\nY1\u000b^1ug\u0016sw-\u001b8f\u0011\u0015\u00018\u00021\u0001r\u0003A\u0019\u0018.\\;mCRLwN\u001c)be\u0006l7\u000f\u0005\u0002sk6\t1O\u0003\u0002u!\u0006A1oY3oCJLw.\u0003\u0002wg\n\u00012+[7vY\u0006$\u0018n\u001c8QCJ\fWn\u001d\u0005\u0006q.\u0001\r!_\u0001\u000beVtW*Z:tC\u001e,\u0007C\u0001>~\u001b\u0005Y(B\u0001?l\u0003\u00199(/\u001b;fe&\u0011ap\u001f\u0002\u000b%VtW*Z:tC\u001e,\u0017\u0001\u0002:v]B\"2aWA\u0002\u0011\u0015yF\u00021\u0001a\u0003\u0015\u0019H/\u0019:u)!\tI!a\u000b\u0002.\u0005]\u0002\u0007BA\u0006\u00033\u0001b!!\u0004\u0002\u0012\u0005UQBAA\b\u0015\t1E$\u0003\u0003\u0002\u0014\u0005=!a\u0001+ssB!\u0011qCA\r\u0019\u0001!1\"a\u0007\u000e\u0003\u0003\u0005\tQ!\u0001\u0002\u001e\t\u0019q\fJ\u0019\u0012\t\u0005}\u0011Q\u0005\t\u00047\u0005\u0005\u0012bAA\u00129\t9aj\u001c;iS:<\u0007cA\u000e\u0002(%\u0019\u0011\u0011\u0006\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003q\u001b\u0001\u0007\u0011\u000fC\u0004\u000205\u0001\r!!\r\u0002\u0013M\u001cWM\\1sS>\u001c\bc\u0001:\u00024%\u0019\u0011QG:\u0003\u0013M\u001bWM\\1sS>\u001c\bbBA\u001d\u001b\u0001\u0007\u00111H\u0001\u000fG>\u0014XmQ8na>tWM\u001c;t!\u0011\ti$a\u0010\u000e\u0003AK1!!\u0011Q\u00059\u0019uN]3D_6\u0004xN\\3oiNDQ\u0001M\u0002A\u0002EBQ!O\u0002A\u0002iBQaS\u0002A\u00021\u0003")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final Logger logger;

    public static Runner apply(ActorSystem actorSystem, EventLoopGroup eventLoopGroup, GatlingConfiguration gatlingConfiguration) {
        return Runner$.MODULE$.apply(actorSystem, eventLoopGroup, gatlingConfiguration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public RunResult run(Option<Class<Simulation>> selectedSimulationClass) {
        RunResult runResult;
        Option option = this.configuration.core().directory().reportsOnly();
        if (option instanceof Some) {
            Some some = (Some)option;
            String runId = (String)some.value();
            runResult = new RunResult(runId, true);
        } else {
            if (this.configuration.http().enableGA()) {
                Ga$.MODULE$.send(this.configuration.core().version());
            }
            runResult = this.run0(selectedSimulationClass);
        }
        return runResult;
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.configuration);
    }

    private RunResult run0(Option<Class<Simulation>> selectedSimulationClass) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        BoxedUnit boxedUnit6;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit6 = BoxedUnit.UNIT;
        } else {
            boxedUnit6 = BoxedUnit.UNIT;
        }
        Predef$.MODULE$._configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(selectedSimulationClass, this.configuration);
        Simulation simulation = selection.simulationClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation instantiated");
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        SimulationParams simulationParams = simulation.params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        simulation.executeBefore();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hooks executed");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), this.configuration.core().version());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Throttler throttler = Throttler$.MODULE$.apply(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, this.eventLoopGroup, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams, this.configuration), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector, this.clock);
        CoreComponents coreComponents = new CoreComponents(this.system, this.eventLoopGroup, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Scenarios scenarios = simulationParams.scenarios(coreComponents);
        Try<?> try_ = this.start(simulationParams, scenarios, coreComponents);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulation.executeAfter();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hooks executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunResult runResult = new RunResult(runMessage.runId(), simulationParams.assertions().nonEmpty());
        return runResult;
    }

    public Try<?> start(SimulationParams simulationParams, Scenarios scenarios, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringBuilder(22).append("Simulation ").append(simulationParams.name()).append(" started...").toString());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarios);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension1(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringBuilder(33).append("Simulation ").append(simulationParams.name()).append(" completed in ").append((coreComponents.clock().nowMillis() - start) / 1000L).append(" seconds").toString());
        return runDone;
    }

    public Runner(ActorSystem system, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.eventLoopGroup = eventLoopGroup;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
    }
}

