/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.app;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.app.Analytics$;
import io.gatling.app.RunResult;
import io.gatling.app.Runner$;
import io.gatling.app.Selection;
import io.gatling.app.Selection$;
import io.gatling.app.SimulationClass;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.GatlingVersion;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.core.CoreComponents;
import io.gatling.core.Predef$;
import io.gatling.core.action.Action;
import io.gatling.core.action.Exit;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.controller.Controller$;
import io.gatling.core.controller.ControllerCommand;
import io.gatling.core.controller.inject.Injector$;
import io.gatling.core.controller.inject.ScenarioFlows;
import io.gatling.core.controller.throttle.Throttler$;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.scenario.SimulationParams;
import io.gatling.core.stats.DataWritersStatsEngine$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.writer.RunMessage;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Et!\u0002\b\u0010\u0011\u00131b!\u0002\r\u0010\u0011\u0013I\u0002\"\u0002\u0011\u0002\t\u0003\t\u0003\"\u0002\u0012\u0002\t\u0003\u0019c!\u0002\r\u0010\u0001E)\u0003\u0002\u0003\u0019\u0005\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011e\"!\u0011!Q\u0001\niB\u0001B\u0011\u0003\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0017\u0012\u0011\t\u0011)A\u0005\u0019\")\u0001\u0005\u0002C\u0001)\"1\u0011\f\u0002C\u0003\u001fiCQA\u001a\u0003\u0005\u0012\u001dDaA \u0003\u0005\u0012Ey\bbBA1\t\u0011E\u00111M\u0001\u0007%Vtg.\u001a:\u000b\u0005A\t\u0012aA1qa*\u0011!cE\u0001\bO\u0006$H.\u001b8h\u0015\u0005!\u0012AA5p\u0007\u0001\u0001\"aF\u0001\u000e\u0003=\u0011aAU;o]\u0016\u00148CA\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AF\u0001\u0006CB\u0004H.\u001f\u000b\bI\u0005-\u0014QNA8!\t9BaE\u0002\u00055\u0019\u0002\"a\n\u0018\u000e\u0003!R!!\u000b\u0016\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005-b\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u00035\n1aY8n\u0013\ty\u0003FA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0007gf\u001cH/Z7\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014!B1di>\u0014(\"\u0001\u001c\u0002\t\u0005\\7.Y\u0005\u0003qM\u00121\"Q2u_J\u001c\u0016p\u001d;f[\u0006qQM^3oi2{w\u000e]$s_V\u0004\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\u001d\u0019\u0007.\u00198oK2T!aP\n\u0002\u000b9,G\u000f^=\n\u0005\u0005c$AD#wK:$Hj\\8q\u000fJ|W\u000f]\u0001\u0006G2|7m\u001b\t\u0003\t&k\u0011!\u0012\u0006\u0003\r\u001e\u000bA!\u001e;jY*\u0011\u0001*E\u0001\bG>lWn\u001c8t\u0013\tQUIA\u0003DY>\u001c7.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003\u001bJk\u0011A\u0014\u0006\u0003\u001fB\u000baaY8oM&<'BA)\u0012\u0003\u0011\u0019wN]3\n\u0005Ms%\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000eF\u0003%+Z;\u0006\fC\u00031\u0013\u0001\u0007\u0011\u0007C\u0003:\u0013\u0001\u0007!\bC\u0003C\u0013\u0001\u00071\tC\u0003L\u0013\u0001\u0007A*A\u0002sk:$\"a\u00170\u0011\u0005]a\u0016BA/\u0010\u0005%\u0011VO\u001c*fgVdG\u000fC\u0003`\u0015\u0001\u0007\u0001-A\u000bg_J\u001cW\rZ*j[Vd\u0017\r^5p]\u000ec\u0017m]:\u0011\u0007m\t7-\u0003\u0002c9\t1q\n\u001d;j_:\u0004\"a\u00063\n\u0005\u0015|!aD*j[Vd\u0017\r^5p]\u000ec\u0017m]:\u0002\u001d9,wo\u0015;biN,enZ5oKR\u0019\u0001N\u001c<\u0011\u0005%dW\"\u00016\u000b\u0005-\u0004\u0016!B:uCR\u001c\u0018BA7k\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\t\u000b=\\\u0001\u0019\u00019\u0002!MLW.\u001e7bi&|g\u000eU1sC6\u001c\bCA9u\u001b\u0005\u0011(BA:Q\u0003!\u00198-\u001a8be&|\u0017BA;s\u0005A\u0019\u0016.\\;mCRLwN\u001c)be\u0006l7\u000fC\u0003x\u0017\u0001\u0007\u00010\u0001\u0006sk:lUm]:bO\u0016\u0004\"!\u001f?\u000e\u0003iT!a\u001f6\u0002\r]\u0014\u0018\u000e^3s\u0013\ti(P\u0001\u0006Sk:lUm]:bO\u0016\fQa\u001d;beR$\u0002\"!\u0001\u0002$\u0005\u0015\u0012Q\u000b\u0019\u0005\u0003\u0007\t\t\u0002\u0005\u0004\u0002\u0006\u0005%\u0011QB\u0007\u0003\u0003\u000fQ!A\u0012\u000f\n\t\u0005-\u0011q\u0001\u0002\u0004)JL\b\u0003BA\b\u0003#a\u0001\u0001B\u0006\u0002\u00141\t\t\u0011!A\u0003\u0002\u0005U!aA0%cE!\u0011qCA\u000f!\rY\u0012\u0011D\u0005\u0004\u00037a\"a\u0002(pi\"Lgn\u001a\t\u00047\u0005}\u0011bAA\u00119\t\u0019\u0011I\\=\t\u000b=d\u0001\u0019\u00019\t\u000f\u0005\u001dB\u00021\u0001\u0002*\u0005i1oY3oCJLwN\u00127poN\u0004\u0002\"a\u000b\u00026\u0005e\u0012qJ\u0007\u0003\u0003[QA!a\f\u00022\u00051\u0011N\u001c6fGRT1!a\rQ\u0003)\u0019wN\u001c;s_2dWM]\u0005\u0005\u0003o\tiCA\u0007TG\u0016t\u0017M]5p\r2|wo\u001d\t\u0005\u0003w\tIE\u0004\u0003\u0002>\u0005\u0015\u0003cAA 95\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007*\u0012A\u0002\u001fs_>$h(C\u0002\u0002Hq\ta\u0001\u0015:fI\u00164\u0017\u0002BA&\u0003\u001b\u0012aa\u0015;sS:<'bAA$9A\u0019\u0011/!\u0015\n\u0007\u0005M#O\u0001\u0005TG\u0016t\u0017M]5p\u0011\u001d\t9\u0006\u0004a\u0001\u00033\nabY8sK\u000e{W\u000e]8oK:$8\u000f\u0005\u0003\u0002\\\u0005uS\"\u0001)\n\u0007\u0005}\u0003K\u0001\bD_J,7i\\7q_:,g\u000e^:\u0002+\u0011L7\u000f\u001d7bsZ+'o]5p]^\u000b'O\\5oOR\u0011\u0011Q\r\t\u00047\u0005\u001d\u0014bAA59\t!QK\\5u\u0011\u0015\u00014\u00011\u00012\u0011\u0015I4\u00011\u0001;\u0011\u0015Y5\u00011\u0001M\u0001")
public class Runner
implements StrictLogging {
    private final ActorSystem system;
    private final EventLoopGroup eventLoopGroup;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private Logger logger;

    public static Runner apply(ActorSystem system, EventLoopGroup eventLoopGroup, GatlingConfiguration configuration) {
        return Runner$.MODULE$.apply(system, eventLoopGroup, configuration);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public final RunResult run(Option<SimulationClass> forcedSimulationClass) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Running");
            boxedUnit5 = BoxedUnit.UNIT;
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        this.displayVersionWarning();
        Predef$.MODULE$._configuration_$eq(this.configuration);
        Selection selection = Selection$.MODULE$.apply(forcedSimulationClass, this.configuration);
        if (this.configuration.data().enableAnalytics()) {
            Analytics$.MODULE$.send(selection.simulationClass(), (Option<String>)this.configuration.data().launcher(), (Option<String>)this.configuration.data().buildToolVersion());
        }
        SimulationParams simulationParams = selection.simulationClass().params(this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Simulation params built");
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        simulationParams.before().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Before hook executed");
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        RunMessage runMessage = new RunMessage(simulationParams.name(), selection.simulationId(), this.clock.nowMillis(), selection.description(), GatlingVersion$.MODULE$.ThisVersion().fullVersion());
        StatsEngine statsEngine = this.newStatsEngine(simulationParams, runMessage);
        Option throttler = Throttler$.MODULE$.newThrottler(this.system, simulationParams);
        ActorRef injector = Injector$.MODULE$.apply(this.system, this.eventLoopGroup, statsEngine, this.clock);
        ActorRef controller = this.system.actorOf(Controller$.MODULE$.props(statsEngine, injector, throttler, simulationParams), Controller$.MODULE$.ControllerActorName());
        Exit exit = new Exit(injector);
        CoreComponents coreComponents = new CoreComponents(this.system, this.eventLoopGroup, controller, throttler, statsEngine, this.clock, (Action)exit, this.configuration);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("CoreComponents instantiated");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        ScenarioFlows scenarioFlows = simulationParams.scenarioFlows(coreComponents);
        Try<?> try_ = this.start(simulationParams, (ScenarioFlows<String, Scenario>)scenarioFlows, coreComponents);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            throw t;
        }
        simulationParams.after().apply$mcV$sp();
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("After hook executed");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RunResult runResult = new RunResult(runMessage.runId(), simulationParams.assertions().nonEmpty());
        return runResult;
    }

    public StatsEngine newStatsEngine(SimulationParams simulationParams, RunMessage runMessage) {
        return DataWritersStatsEngine$.MODULE$.apply(simulationParams, runMessage, this.system, this.clock, this.configuration);
    }

    public Try<?> start(SimulationParams simulationParams, ScenarioFlows<String, Scenario> scenarioFlows, CoreComponents coreComponents) {
        BoxedUnit boxedUnit;
        FiniteDuration timeout = new package.DurationInt(package$.MODULE$.DurationInt(Integer.MAX_VALUE)).milliseconds().$minus(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
        long start = coreComponents.clock().nowMillis();
        scala.Predef$.MODULE$.println((Object)new StringBuilder(22).append("Simulation ").append(simulationParams.name()).append(" started...").toString());
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Asking Controller to start");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(coreComponents.controller());
        ControllerCommand.Start x$1 = new ControllerCommand.Start(scenarioFlows);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(timeout);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        Future whenRunDone = AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).mapTo(ClassTag$.MODULE$.apply(Try.class));
        Try runDone = (Try)Await$.MODULE$.result((Awaitable)whenRunDone, (Duration)timeout);
        scala.Predef$.MODULE$.println((Object)new StringBuilder(33).append("Simulation ").append(simulationParams.name()).append(" completed in ").append((coreComponents.clock().nowMillis() - start) / 1000L).append(" seconds").toString());
        return runDone;
    }

    public void displayVersionWarning() {
        GatlingVersion$.MODULE$.LatestRelease().foreach((Function1 & Serializable)latest -> {
            Runner.$anonfun$displayVersionWarning$1(latest);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$displayVersionWarning$1(GatlingVersion latest) {
        block0: {
            if (!latest.releaseDate().isAfter(GatlingVersion$.MODULE$.ThisVersion().releaseDate())) break block0;
            scala.Predef$.MODULE$.println((Object)new StringBuilder(38).append("Gatling ").append(latest.fullVersion()).append(" is available! (you're using ").append(GatlingVersion$.MODULE$.ThisVersion().fullVersion()).append(")").toString());
        }
    }

    public Runner(ActorSystem system, EventLoopGroup eventLoopGroup, Clock clock, GatlingConfiguration configuration) {
        this.system = system;
        this.eventLoopGroup = eventLoopGroup;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

